"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProcessingCopyToSpace = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _space_result = require("./space_result");
var _lib = require("../lib");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const renderCopyOptions = ({
  createNewCopies,
  overwrite,
  includeRelated
}) => {
  const createNewCopiesLabel = createNewCopies ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.spaces.management.copyToSpace.createNewCopiesLabel",
    defaultMessage: "Create new objects with random IDs"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.spaces.management.copyToSpace.dontCreateNewCopiesLabel",
    defaultMessage: "Check for existing objects"
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    className: "spcCopyToSpaceOptionsView",
    flush: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    iconType: "copy",
    label: createNewCopiesLabel
  }), !createNewCopies && /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    iconType: overwrite ? 'check' : 'cross',
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.management.copyToSpace.overwriteLabel",
      defaultMessage: "Automatically overwrite conflicts"
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    iconType: includeRelated ? 'check' : 'cross',
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.management.copyToSpace.includeRelatedLabel",
      defaultMessage: "Include related saved objects"
    })
  }));
};
const ProcessingCopyToSpace = props => {
  function updateRetries(spaceId, updatedRetries) {
    props.onRetriesChange({
      ...props.retries,
      [spaceId]: updatedRetries
    });
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "copy-to-space-processing"
  }, renderCopyOptions(props.copyOptions), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.spaces.management.copyToSpace.copyResultsLabel",
    defaultMessage: "Results"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), props.copyOptions.selectedSpaceIds.map(id => {
    const space = props.spaces.find(s => s.id === id);
    const spaceCopyResult = props.copyResult[space.id];
    const summarizedSpaceCopyResult = (0, _lib.summarizeCopyResult)(props.savedObjectTarget, spaceCopyResult);
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: id
    }, summarizedSpaceCopyResult.processing ? /*#__PURE__*/_react.default.createElement(_space_result.SpaceResultProcessing, {
      space: space
    }) : /*#__PURE__*/_react.default.createElement(_space_result.SpaceResult, {
      space: space,
      summarizedCopyResult: summarizedSpaceCopyResult,
      retries: props.retries[space.id] || [],
      onRetriesChange: retries => updateRetries(space.id, retries),
      conflictResolutionInProgress: props.conflictResolutionInProgress
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }));
  }));
};
exports.ProcessingCopyToSpace = ProcessingCopyToSpace;