"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyDeleteProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _app_context = require("../app_context");
var _http = require("../services/http");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PolicyDeleteProvider = ({
  children
}) => {
  const {
    i18n
  } = (0, _app_context.useServices)();
  const toastNotifications = (0, _app_context.useToastNotifications)();
  const [policyNames, setPolicyNames] = (0, _react.useState)([]);
  const [isModalOpen, setIsModalOpen] = (0, _react.useState)(false);
  const onSuccessCallback = (0, _react.useRef)(null);
  const deletePolicyPrompt = (names, onSuccess = () => undefined) => {
    if (!names || !names.length) {
      throw new Error('No policy names specified for deletion');
    }
    setIsModalOpen(true);
    setPolicyNames(names);
    onSuccessCallback.current = onSuccess;
  };
  const closeModal = () => {
    setIsModalOpen(false);
    setPolicyNames([]);
  };
  const deletePolicy = () => {
    const policiesToDelete = [...policyNames];
    (0, _http.deletePolicies)(policiesToDelete).then(({
      data,
      error
    }) => {
      const {
        itemsDeleted,
        errors
      } = data || {
        itemsDeleted: undefined,
        errors: undefined
      };

      // Surface success notifications
      if (itemsDeleted && itemsDeleted.length) {
        const hasMultipleSuccesses = itemsDeleted.length > 1;
        const successMessage = hasMultipleSuccesses ? i18n.translate('xpack.snapshotRestore.deletePolicy.successMultipleNotificationTitle', {
          defaultMessage: 'Deleted {count} policies',
          values: {
            count: itemsDeleted.length
          }
        }) : i18n.translate('xpack.snapshotRestore.deletePolicy.successSingleNotificationTitle', {
          defaultMessage: "Deleted policy '{name}'",
          values: {
            name: itemsDeleted[0]
          }
        });
        toastNotifications.addSuccess(successMessage);
        if (onSuccessCallback.current) {
          onSuccessCallback.current([...itemsDeleted]);
        }
      }

      // Surface error notifications
      // `error` is generic server error
      // `data.errors` are specific errors with removing particular policy(ies)
      if (error || errors && errors.length) {
        const hasMultipleErrors = errors && errors.length > 1 || error && policiesToDelete.length > 1;
        const errorMessage = hasMultipleErrors ? i18n.translate('xpack.snapshotRestore.deletePolicy.errorMultipleNotificationTitle', {
          defaultMessage: 'Error deleting {count} policies',
          values: {
            count: errors && errors.length || policiesToDelete.length
          }
        }) : i18n.translate('xpack.snapshotRestore.deletePolicy.errorSingleNotificationTitle', {
          defaultMessage: "Error deleting policy '{name}'",
          values: {
            name: errors && errors[0].name || policiesToDelete[0]
          }
        });
        toastNotifications.addDanger(errorMessage);
      }
    });
    closeModal();
  };
  const renderModal = () => {
    if (!isModalOpen) {
      return null;
    }
    const isSingle = policyNames.length === 1;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
      title: isSingle ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.deletePolicy.confirmModal.deleteSingleTitle",
        defaultMessage: "Delete policy '{name}'?",
        values: {
          name: policyNames[0]
        }
      }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.deletePolicy.confirmModal.deleteMultipleTitle",
        defaultMessage: "Delete {count} policies?",
        values: {
          count: policyNames.length
        }
      }),
      onCancel: closeModal,
      onConfirm: deletePolicy,
      cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.deletePolicy.confirmModal.cancelButtonLabel",
        defaultMessage: "Cancel"
      }),
      confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.deletePolicy.confirmModal.confirmButtonLabel",
        defaultMessage: "Delete {count, plural, one {policy} other {policies}}",
        values: {
          count: policyNames.length
        }
      }),
      buttonColor: "danger",
      "data-test-subj": "srdeletePolicyConfirmationModal"
    }, !isSingle ? /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.deletePolicy.confirmModal.deleteMultipleListDescription",
      defaultMessage: "You are about to delete these policies:"
    })), /*#__PURE__*/_react.default.createElement("ul", null, policyNames.map(name => /*#__PURE__*/_react.default.createElement("li", {
      key: name
    }, name)))) : null);
  };
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, children(deletePolicyPrompt), renderModal());
};
exports.PolicyDeleteProvider = PolicyDeleteProvider;