"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServerlessSearchPlugin = void 0;
var _public = require("@kbn/core/public");
var _i18n = require("@kbn/i18n");
var _managementCardsNavigation = require("@kbn/management-cards-navigation");
var _index_mappings_docs_link = require("./application/components/index_mappings_docs_link");
var _nav = require("./layout/nav");
var _doc_links = require("../common/doc_links");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
class ServerlessSearchPlugin {
  setup(core, _setupDeps) {
    core.application.register({
      id: 'serverlessElasticsearch',
      title: _i18n.i18n.translate('xpack.serverlessSearch.app.elasticsearch.title', {
        defaultMessage: 'Elasticsearch'
      }),
      euiIconType: 'logoElastic',
      category: _public.DEFAULT_APP_CATEGORIES.enterpriseSearch,
      appRoute: '/app/elasticsearch',
      async mount({
        element,
        history
      }) {
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application/elasticsearch')));
        const [coreStart, services] = await core.getStartServices();
        const {
          security
        } = services;
        _doc_links.docLinks.setDocLinks(coreStart.docLinks.links);
        let user;
        try {
          const response = await security.authc.getCurrentUser();
          user = response;
        } catch {
          user = undefined;
        }
        return await renderApp(element, coreStart, {
          history,
          user,
          ...services
        });
      }
    });
    core.application.register({
      id: 'serverlessConnectors',
      title: _i18n.i18n.translate('xpack.serverlessSearch.app.connectors.title', {
        defaultMessage: 'Connectors'
      }),
      appRoute: '/app/connectors',
      euiIconType: 'logoElastic',
      category: _public.DEFAULT_APP_CATEGORIES.enterpriseSearch,
      searchable: false,
      async mount({
        element,
        history
      }) {
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application/connectors')));
        const [coreStart, services] = await core.getStartServices();
        _doc_links.docLinks.setDocLinks(coreStart.docLinks.links);
        return await renderApp(element, coreStart, {
          history,
          ...services
        });
      }
    });
    return {};
  }
  start(core, {
    serverless,
    management,
    cloud,
    indexManagement
  }) {
    serverless.setProjectHome('/app/elasticsearch');
    serverless.setSideNavComponent((0, _nav.createServerlessSearchSideNavComponent)(core, {
      serverless,
      cloud
    }));
    management.setIsSidebarEnabled(false);
    management.setupCardsNavigation({
      enabled: true,
      hideLinksTo: [_managementCardsNavigation.appIds.MAINTENANCE_WINDOWS]
    });
    indexManagement === null || indexManagement === void 0 ? void 0 : indexManagement.extensionsService.setIndexMappingsContent((0, _index_mappings_docs_link.createIndexMappingsDocsLinkContent)(core));
    return {};
  }
  stop() {}
}
exports.ServerlessSearchPlugin = ServerlessSearchPlugin;