"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorIndexName = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _searchConnectors = require("@kbn/search-connectors");
var _react = _interopRequireWildcard(require("react"));
var _reactQuery = require("@tanstack/react-query");
var _validate_index_name = require("../../../../utils/validate_index_name");
var _i18n_string = require("../../../../../common/i18n_string");
var _use_connector = require("../../../hooks/api/use_connector");
var _use_kibana = require("../../../hooks/use_kibana");
var _api_key_panel = require("./api_key_panel");
var _connector_index_name_form = require("./connector_index_name_form");
var _use_error_toast = require("../../../hooks/use_error_toast");
var _sync_scheduled_callout = require("./sync_scheduled_callout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorIndexName = ({
  connector
}) => {
  const {
    http
  } = (0, _use_kibana.useKibanaServices)();
  const queryClient = (0, _reactQuery.useQueryClient)();
  const {
    queryKey
  } = (0, _use_connector.useConnector)(connector.id);
  const showErrorToast = (0, _use_error_toast.useShowErrorToast)();
  const {
    data,
    isLoading,
    isSuccess,
    mutate
  } = (0, _reactQuery.useMutation)({
    mutationFn: async ({
      inputName,
      sync
    }) => {
      if (inputName && inputName !== connector.index_name) {
        const body = {
          index_name: inputName
        };
        await http.post(`/internal/serverless_search/connectors/${connector.id}/index_name`, {
          body: JSON.stringify(body)
        });
      }
      if (sync) {
        await http.post(`/internal/serverless_search/connectors/${connector.id}/sync`);
      }
      return inputName;
    },
    onError: error => showErrorToast(error, _i18n.i18n.translate('xpack.serverlessSearch.connectors.config.connectorIndexNameError', {
      defaultMessage: 'Error updating index name'
    })),
    onSuccess: () => {
      queryClient.setQueryData(queryKey, {
        connector: {
          ...connector,
          index_name: data
        }
      });
      queryClient.invalidateQueries(queryKey);
    }
  });
  const [newIndexName, setNewIndexname] = (0, _react.useState)(connector.index_name);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "center",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.serverlessSearch.connectors.config.connectorIndexNameTitle', {
    defaultMessage: 'Link index'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, _i18n.i18n.translate('xpack.serverlessSearch.connectors.config.connectorIndexNameDescription', {
    defaultMessage: 'Pick an index where your documents will be synced, or create a new one for this connector.'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_connector_index_name_form.ConnectorIndexNameForm, {
    indexName: newIndexName || '',
    onChange: name => setNewIndexname(name)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_api_key_panel.ApiKeyPanel, {
    connector: connector
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "serverlessSearchConnectorIndexNameButton",
    color: "primary",
    isDisabled: !(0, _validate_index_name.isValidIndexName)(newIndexName),
    isLoading: isLoading,
    onClick: () => mutate({
      inputName: newIndexName,
      sync: false
    })
  }, _i18n_string.SAVE_LABEL))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "serverlessSearchConnectorIndexNameSaveAndSyncButton",
    color: "primary",
    disabled: !((0, _validate_index_name.isValidIndexName)(newIndexName) && [_searchConnectors.ConnectorStatus.CONFIGURED, _searchConnectors.ConnectorStatus.CONNECTED].includes(connector.status)),
    fill: true,
    isLoading: isLoading,
    onClick: () => mutate({
      inputName: newIndexName,
      sync: true
    })
  }, _i18n.i18n.translate('xpack.serverlessSearch.connectors.config.saveSyncLabel', {
    defaultMessage: 'Save and sync'
  }))))), isSuccess && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_sync_scheduled_callout.SyncScheduledCallOut, null)));
};
exports.ConnectorIndexName = ConnectorIndexName;