"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createObservabilityDashboardRegistration = createObservabilityDashboardRegistration;
var rt = _interopRequireWildcard(require("io-ts"));
var _rxjs = require("rxjs");
var _ioTsUtils = require("@kbn/io-ts-utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// check log data streams that match the naming convention, except for the APM
// error stream, because its presence would always mask the "APM only" case
const LOG_DATA_INDICES = 'logs-*-*,-logs-apm.error-*';
function createObservabilityDashboardRegistration({
  search
}) {
  return {
    appName: 'infra_logs',
    fetchData: fetchObservabilityDashboardData,
    hasData: hasObservabilityDashboardData({
      search
    })
  };
}
async function fetchObservabilityDashboardData() {
  throw new Error('Overview data fetching has not been implemented for serverless deployments.');
}
const hasObservabilityDashboardData = ({
  search
}) => async () => {
  const hasData = await (0, _rxjs.lastValueFrom)((await search)({
    params: {
      ignore_unavailable: true,
      allow_no_indices: true,
      index: LOG_DATA_INDICES,
      size: 0,
      terminate_after: 1,
      track_total_hits: 1
    }
  })).then(({
    rawResponse
  }) => {
    if (rawResponse._shards.total <= 0) {
      return false;
    }
    const totalHits = decodeTotalHits(rawResponse.hits.total);
    if (typeof totalHits === 'number' ? totalHits > 0 : totalHits.value > 0) {
      return true;
    }
    return false;
  }, err => {
    if (err.status === 404) {
      return false;
    }
    throw new Error(`Failed to check status of log indices "${LOG_DATA_INDICES}": ${err}`);
  });
  return {
    hasData,
    indices: LOG_DATA_INDICES
  };
};
const decodeTotalHits = (0, _ioTsUtils.decodeOrThrow)(rt.union([rt.number, rt.type({
  value: rt.number
})]));