"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.threatsOrUndefined = exports.threats = exports.threat_framework = exports.threat = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _threat_tactic = require("../threat_tactic");
var _threat_technique = require("../threat_technique");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/* eslint-disable @typescript-eslint/naming-convention */

const threat_framework = t.string;
exports.threat_framework = threat_framework;
const threat = t.intersection([t.exact(t.type({
  framework: threat_framework,
  tactic: _threat_tactic.threat_tactic
})), t.exact(t.partial({
  technique: _threat_technique.threat_techniques
}))]);
exports.threat = threat;
const threats = t.array(threat);
exports.threats = threats;
const threatsOrUndefined = t.union([threats, t.undefined]);
exports.threatsOrUndefined = threatsOrUndefined;