"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getProductAppFeaturesConfigurator = void 0;
var _cases_app_features_config = require("./cases_app_features_config");
var _security_app_features_config = require("./security_app_features_config");
var _security_assistant_app_features_config = require("./security_assistant_app_features_config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getProductAppFeaturesConfigurator = (enabledAppFeatureKeys, config) => {
  return {
    security: (0, _security_app_features_config.getSecurityAppFeaturesConfigurator)(enabledAppFeatureKeys, config.experimentalFeatures),
    cases: (0, _cases_app_features_config.getCasesAppFeaturesConfigurator)(enabledAppFeatureKeys),
    securityAssistant: (0, _security_assistant_app_features_config.getSecurityAssistantAppFeaturesConfigurator)(enabledAppFeatureKeys)
  };
};
exports.getProductAppFeaturesConfigurator = getProductAppFeaturesConfigurator;