"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setRoutes = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _services = require("../common/services");
var _constants = require("../navigation/links/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const withSuspense = Component => function LazyPageWithSuspense(props) {
  return /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xl"
    })
  }, /*#__PURE__*/_react.default.createElement(Component, props));
};
const InvestigationsPageLazy = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./investigations'))));
const InvestigationsPage = withSuspense(InvestigationsPageLazy);
const AssetsPageLazy = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./assets'))));
const AssetsPage = withSuspense(AssetsPageLazy);
const MachineLearningPageLazy = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./machine_learning'))));
const MachineLearningPage = withSuspense(MachineLearningPageLazy);

// Sets the project specific routes for Serverless as extra routes in the Security Solution plugin
const setRoutes = services => {
  const projectRoutes = [{
    path: _constants.SecurityPagePath[_securitySolutionNavigation.SecurityPageName.investigations],
    component: (0, _services.withServicesProvider)(InvestigationsPage, services)
  }, {
    path: _constants.SecurityPagePath[_securitySolutionNavigation.SecurityPageName.assets],
    component: (0, _services.withServicesProvider)(AssetsPage, services)
  }, {
    path: _constants.SecurityPagePath[_securitySolutionNavigation.SecurityPageName.mlLanding],
    component: (0, _services.withServicesProvider)(MachineLearningPage, services)
  }];
  services.securitySolution.setExtraRoutes(projectRoutes);
};
exports.setRoutes = setRoutes;