"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.SecuritySideNavigation = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _securitySolutionSideNav = require("@kbn/security-solution-side-nav");
var _reactUse = require("react-use");
var _react2 = require("@emotion/react");
var _fp = require("lodash/fp");
var _use_side_nav_items = require("./use_side_nav_items");
var _categories = require("../categories");
var _util = require("../links/util");
var _services = require("../../common/services");
var _side_navigation_footer = require("./side_navigation_footer");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getEuiNavItemFromSideNavItem = (sideNavItem, selectedId) => ({
  id: sideNavItem.id,
  title: sideNavItem.label,
  isSelected: sideNavItem.id === selectedId,
  href: sideNavItem.href,
  onClick: sideNavItem.onClick
});
const SecuritySideNavigation = /*#__PURE__*/_react.default.memo(function SecuritySideNavigation({
  activeNodes: [activeChromeNodes]
}) {
  var _activeChromeNodes$0$;
  const {
    chrome
  } = (0, _services.useKibana)().services;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const hasHeaderBanner = (0, _reactUse.useObservable)(chrome.hasHeaderBanner$());
  const isCollapsed = (0, _reactUse.useObservable)(chrome.getIsSideNavCollapsed$());
  const items = (0, _use_side_nav_items.useSideNavItems)();
  const isLoading = items.length === 0;
  // we only care about the first node to highlight a left nav main item
  const activeNodeId = (_activeChromeNodes$0$ = activeChromeNodes === null || activeChromeNodes === void 0 ? void 0 : activeChromeNodes[0].id) !== null && _activeChromeNodes$0$ !== void 0 ? _activeChromeNodes$0$ : '';
  const panelTopOffset = (0, _react.useMemo)(() => hasHeaderBanner ? `calc((${euiTheme.size.l} * 2) + ${euiTheme.size.xl})` : `calc(${euiTheme.size.l} * 2)`, [hasHeaderBanner, euiTheme]);
  const selectedId = (0, _react.useMemo)(() => activeNodeId ? (0, _util.getProjectPageNameFromNavLinkId)(activeNodeId) : '', [activeNodeId]);
  const bodyStyle = (0, _react2.css)`
    padding-left: calc(${euiTheme.size.xl} + ${euiTheme.size.s});
    padding-right: ${euiTheme.size.s};
  `;
  const collapsedBodyItems = (0, _react.useMemo)(() => {
    return _categories.CATEGORIES.reduce((links, category) => {
      const categoryLinks = items.filter(item => category.linkIds.includes(item.id));
      links.push(...categoryLinks.map(link => getEuiNavItemFromSideNavItem(link, selectedId)));
      return links;
    }, []);
  }, [items, selectedId]);
  const [bodyItems, footerItems] = (0, _react.useMemo)(() => (0, _fp.partition)(item => item.position === _securitySolutionSideNav.SolutionSideNavItemPosition.top, items), [items]);
  return isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m",
    "data-test-subj": "sideNavLoader"
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCollapsibleNavBeta.Body, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCollapsibleNavItem, {
    title: "Security",
    icon: "logoSecurity",
    iconProps: {
      size: 'm'
    },
    "data-test-subj": "securitySolutionNavHeading",
    items: isCollapsed ? collapsedBodyItems : undefined
  }), !isCollapsed && /*#__PURE__*/_react.default.createElement("div", {
    css: bodyStyle
  }, /*#__PURE__*/_react.default.createElement(_securitySolutionSideNav.SolutionSideNav, {
    items: bodyItems,
    categories: _categories.CATEGORIES,
    selectedId: selectedId,
    panelTopOffset: panelTopOffset
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiCollapsibleNavBeta.Footer, null, /*#__PURE__*/_react.default.createElement(_side_navigation_footer.SideNavigationFooter, {
    activeNodeId: activeNodeId,
    items: footerItems,
    categories: _categories.FOOTER_CATEGORIES
  })));
});

// eslint-disable-next-line import/no-default-export
exports.SecuritySideNavigation = SecuritySideNavigation;
var _default = SecuritySideNavigation;
exports.default = _default;