"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatProjectDeepLinks = void 0;
var _public = require("@kbn/core/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formatProjectDeepLinks = appLinks => appLinks.map(appLink => {
  var _appLink$links;
  return {
    id: appLink.id,
    path: appLink.path,
    title: appLink.title,
    searchable: !appLink.globalSearchDisabled,
    navLinkStatus: appLink.sideNavDisabled ? _public.AppNavLinkStatus.hidden : _public.AppNavLinkStatus.visible,
    ...(appLink.globalSearchKeywords != null ? {
      keywords: appLink.globalSearchKeywords
    } : {}),
    ...(appLink.links && (_appLink$links = appLink.links) !== null && _appLink$links !== void 0 && _appLink$links.length ? {
      deepLinks: formatProjectDeepLinks(appLink.links)
    } : {})
  };
});
exports.formatProjectDeepLinks = formatProjectDeepLinks;