"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecurityPagePath = exports.ExternalPageName = void 0;
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Paths for internal Security pages that only exist in serverless projects and do not exist on ESS
const SecurityPagePath = {
  [_securitySolutionNavigation.SecurityPageName.investigations]: '/investigations',
  [_securitySolutionNavigation.SecurityPageName.mlLanding]: '/ml',
  [_securitySolutionNavigation.SecurityPageName.assets]: '/assets',
  [_securitySolutionNavigation.SecurityPageName.cloudDefend]: '/cloud_defend'
};

/**
 * External (non-Security) page names that need to be linked in the Security nav for serverless
 * Format: `<pluginId>:<deepLinkId>/<path>`.
 *
 * `pluginId`: is the id of the plugin that owns the deep link
 *
 * `deepLinkId`: is the id of the deep link inside the plugin.
 * Keep empty for the root page of the plugin, e.g. `osquery:`
 *
 * `path`: is the path to append to the plugin and deep link.
 * This is optional and only needed if the path is not registered in the plugin's `deepLinks`. e.g. `integrations:/browse/security`
 * The path should not be used for links displayed in the main left navigation, since highlighting won't work.
 **/
exports.SecurityPagePath = SecurityPagePath;
let ExternalPageName;
exports.ExternalPageName = ExternalPageName;
(function (ExternalPageName) {
  ExternalPageName["discover"] = "discover:";
  ExternalPageName["osquery"] = "osquery:";
  ExternalPageName["maps"] = "maps:";
  ExternalPageName["visualize"] = "visualize:";
  ExternalPageName["mlOverview"] = "ml:overview";
  ExternalPageName["mlNotifications"] = "ml:notifications";
  ExternalPageName["mlMemoryUsage"] = "ml:memoryUsage";
  ExternalPageName["mlAnomalyDetection"] = "ml:anomalyDetection";
  ExternalPageName["mlAnomalyExplorer"] = "ml:anomalyExplorer";
  ExternalPageName["mlSingleMetricViewer"] = "ml:singleMetricViewer";
  ExternalPageName["mlSettings"] = "ml:settings";
  ExternalPageName["mlDataFrameAnalytics"] = "ml:dataFrameAnalytics";
  ExternalPageName["mlResultExplorer"] = "ml:resultExplorer";
  ExternalPageName["mlAnalyticsMap"] = "ml:analyticsMap";
  ExternalPageName["mlNodesOverview"] = "ml:nodesOverview";
  ExternalPageName["mlNodes"] = "ml:nodes";
  ExternalPageName["mlFileUpload"] = "ml:fileUpload";
  ExternalPageName["mlIndexDataVisualizer"] = "ml:indexDataVisualizer";
  ExternalPageName["mlDataDrift"] = "ml:dataDrift";
  ExternalPageName["mlExplainLogRateSpikes"] = "ml:logRateAnalysis";
  ExternalPageName["mlLogPatternAnalysis"] = "ml:logPatternAnalysis";
  ExternalPageName["mlChangePointDetections"] = "ml:changePointDetections";
  ExternalPageName["devTools"] = "dev_tools:";
  ExternalPageName["fleet"] = "fleet:";
  ExternalPageName["fleetAgents"] = "fleet:agents";
  ExternalPageName["fleetPolicies"] = "fleet:policies";
  ExternalPageName["fleetEnrollmentTokens"] = "fleet:enrollment_tokens";
  ExternalPageName["fleetUninstallTokens"] = "fleet:uninstall_tokens";
  ExternalPageName["fleetDataStreams"] = "fleet:data_streams";
  ExternalPageName["fleetSettings"] = "fleet:settings";
  ExternalPageName["integrationsSecurity"] = "integrations:/browse/security";
  ExternalPageName["management"] = "management:";
  ExternalPageName["managementIngestPipelines"] = "management:ingest_pipelines";
  ExternalPageName["managementPipelines"] = "management:pipelines";
  ExternalPageName["managementIndexManagement"] = "management:index_management";
  ExternalPageName["managementTransforms"] = "management:transform";
  ExternalPageName["managementMaintenanceWindows"] = "management:maintenanceWindows";
  ExternalPageName["managementTriggersActions"] = "management:triggersActions";
  ExternalPageName["managementCases"] = "management:cases";
  ExternalPageName["managementTriggersActionsConnectors"] = "management:triggersActionsConnectors";
  ExternalPageName["managementReporting"] = "management:reporting";
  ExternalPageName["managementJobsListLink"] = "management:jobsListLink";
  ExternalPageName["managementDataViews"] = "management:dataViews";
  ExternalPageName["managementObjects"] = "management:objects";
  ExternalPageName["managementApiKeys"] = "management:api_keys";
  ExternalPageName["managementTags"] = "management:tags";
  ExternalPageName["managementFiles"] = "management:filesManagement";
  ExternalPageName["managementSpaces"] = "management:spaces";
  ExternalPageName["managementSettings"] = "management:settings";
  ExternalPageName["cloudUsersAndRoles"] = "cloud:usersAndRoles";
  ExternalPageName["cloudBilling"] = "cloud:billing";
  ExternalPageName["cloudPerformance"] = "cloud:performance";
})(ExternalPageName || (exports.ExternalPageName = ExternalPageName = {}));