"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FOOTER_CATEGORIES = exports.CATEGORIES = void 0;
var _i18n = require("@kbn/i18n");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _constants = require("./links/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CATEGORIES = [{
  type: _securitySolutionNavigation.LinkCategoryType.separator,
  linkIds: [_constants.ExternalPageName.discover, _securitySolutionNavigation.SecurityPageName.dashboards]
}, {
  type: _securitySolutionNavigation.LinkCategoryType.separator,
  linkIds: [_securitySolutionNavigation.SecurityPageName.rulesLanding, _securitySolutionNavigation.SecurityPageName.alerts, _securitySolutionNavigation.SecurityPageName.cloudSecurityPostureFindings, _securitySolutionNavigation.SecurityPageName.case]
}, {
  type: _securitySolutionNavigation.LinkCategoryType.separator,
  linkIds: [_securitySolutionNavigation.SecurityPageName.investigations, _securitySolutionNavigation.SecurityPageName.threatIntelligence, _securitySolutionNavigation.SecurityPageName.exploreLanding]
}, {
  type: _securitySolutionNavigation.LinkCategoryType.separator,
  linkIds: [_constants.ExternalPageName.fleet, _securitySolutionNavigation.SecurityPageName.assets]
}, {
  type: _securitySolutionNavigation.LinkCategoryType.separator,
  linkIds: [_securitySolutionNavigation.SecurityPageName.mlLanding]
}];
exports.CATEGORIES = CATEGORIES;
const FOOTER_CATEGORIES = [{
  type: _securitySolutionNavigation.LinkCategoryType.separator,
  linkIds: [_securitySolutionNavigation.SecurityPageName.landing, _constants.ExternalPageName.devTools]
}, {
  type: _securitySolutionNavigation.LinkCategoryType.accordion,
  label: _i18n.i18n.translate('xpack.securitySolutionServerless.nav.projectSettings.title', {
    defaultMessage: 'Project settings'
  }),
  iconType: 'gear',
  linkIds: [_constants.ExternalPageName.management, _constants.ExternalPageName.integrationsSecurity, _constants.ExternalPageName.cloudUsersAndRoles, _constants.ExternalPageName.cloudPerformance, _constants.ExternalPageName.cloudBilling]
}];
exports.FOOTER_CATEGORIES = FOOTER_CATEGORIES;