"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProductTierBadge = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _product = require("../../../common/product");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ProductTierBadgeComponent = ({
  productTier
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return productTier ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "warning",
    className: "eui-alignMiddle",
    css: (0, _react2.css)`
        font-size: ${euiTheme.size.m};
        line-height: ${euiTheme.size.m};
      `,
    "data-test-subj": "product-tier-badge"
  }, /*#__PURE__*/_react.default.createElement("strong", null, productTier === _product.ProductTier.essentials && _translations.PRODUCT_TIER_ESSENTIAL, productTier === _product.ProductTier.complete && _translations.PRODUCT_TIER_COMPLETE)) : null;
};
const ProductTierBadge = /*#__PURE__*/_react.default.memo(ProductTierBadgeComponent);
exports.ProductTierBadge = ProductTierBadge;