"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WelcomeHeader = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _use_user_name = require("../../common/hooks/use_user_name");
var _util = require("../../navigation/links/util");
var _translations = require("../translations");
var _helpers = require("../helpers");
var _product_tier_badge = require("./product_tier_badge");
var _services = require("../../common/services");
var _welcome_header = require("../styles/welcome_header.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WelcomeHeaderComponent = ({
  productTier
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const userName = (0, _use_user_name.useUserName)();
  const {
    cloud
  } = (0, _services.useKibana)().services;
  const {
    headerStyles,
    headerTitleStyles,
    headerSubtitleStyles,
    headerDescriptionStyles,
    currentPlanWrapperStyles,
    currentPlanTextStyles
  } = (0, _welcome_header.useWelcomeHeaderStyles)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: headerStyles,
    "data-test-subj": "welcome-header"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react2.css)`
          width: ${_helpers.CONTENT_WIDTH / 2}px;
        `
  }, userName && /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l",
    css: headerTitleStyles
  }, /*#__PURE__*/_react.default.createElement("span", null, (0, _translations.GET_STARTED_PAGE_TITLE)(userName))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement("span", {
    css: headerSubtitleStyles,
    className: "eui-displayBlock"
  }, _translations.GET_STARTED_PAGE_SUBTITLE), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement("span", {
    className: "eui-displayBlock",
    css: headerDescriptionStyles
  }, _translations.GET_STARTED_PAGE_DESCRIPTION), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-displayInlineBlock",
    css: currentPlanWrapperStyles
  }, /*#__PURE__*/_react.default.createElement("span", {
    css: currentPlanTextStyles
  }, _translations.CURRENT_PLAN_LABEL), /*#__PURE__*/_react.default.createElement(_product_tier_badge.ProductTierBadge, {
    productTier: productTier
  }), productTier && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    className: "eui-alignMiddle",
    color: "primary",
    href: (0, _util.getProjectFeaturesUrl)(cloud),
    target: "_blank",
    "aria-label": _translations.CURRENT_PLAN_LABEL,
    iconType: "gear",
    size: "xs",
    css: (0, _react2.css)`
                  padding-left: ${euiTheme.size.xs};
                `
  })))));
};
const WelcomeHeader = /*#__PURE__*/_react.default.memo(WelcomeHeaderComponent);
exports.WelcomeHeader = WelcomeHeader;