"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStepContentStyles = exports.RIGHT_CONTENT_WIDTH = exports.RIGHT_CONTENT_PANEL_WIDTH = exports.RIGHT_CONTENT_HEIGHT = exports.LEFT_CONTENT_PANEL_WIDTH = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LEFT_CONTENT_PANEL_WIDTH = 486;
exports.LEFT_CONTENT_PANEL_WIDTH = LEFT_CONTENT_PANEL_WIDTH;
const RIGHT_CONTENT_PANEL_WIDTH = 510;
exports.RIGHT_CONTENT_PANEL_WIDTH = RIGHT_CONTENT_PANEL_WIDTH;
const RIGHT_CONTENT_HEIGHT = 320;
exports.RIGHT_CONTENT_HEIGHT = RIGHT_CONTENT_HEIGHT;
const RIGHT_CONTENT_WIDTH = 480;
exports.RIGHT_CONTENT_WIDTH = RIGHT_CONTENT_WIDTH;
const useStepContentStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const imageShadow = (0, _eui.useEuiShadow)('s');
  const customStyles = (0, _react2.useMemo)(() => ({
    stepContentGroupStyles: (0, _react.css)`
        &.step-content-group {
          justify-content: space-between;
          margin-top: ${euiTheme.size.l};
          padding: ${euiTheme.size.l};
          transition: opacity ${euiTheme.animation.normal};
          overflow: hidden;
          border: 1px solid ${euiTheme.colors.lightShade};
          border-radius: ${euiTheme.border.radius.medium};
        }
      `,
    leftContentStyles: (0, _react.css)`
        &.left-panel {
          padding: 0 0 0 ${euiTheme.size.s};
          width: ${LEFT_CONTENT_PANEL_WIDTH}px;
        }
      `,
    descriptionStyles: (0, _react.css)`
        &.step-content-description {
          margin-bottom: 0px;
          margin-block-end: 0px !important;
          line-height: ${euiTheme.size.l};

          .step-paragraph {
            margin-top: ${euiTheme.size.xl};
          }
        }
      `,
    rightPanelStyles: (0, _react.css)`
        &.right-panel {
          padding: 0 6px 0 ${euiTheme.size.l};
          width: ${RIGHT_CONTENT_PANEL_WIDTH}px;
        }
      `,
    rightPanelContentStyles: (0, _react.css)`
        &.right-panel-wrapper {
          height: ${RIGHT_CONTENT_HEIGHT}px;
          width: ${RIGHT_CONTENT_WIDTH}px;
        }
      `,
    getRightContentStyles: ({
      shadow
    }) => (0, _react.css)`
        &.right-panel-content {
          height: 100%;
          width: 100%;
          position: relative;
          overflow: hidden;
          ${shadow ? imageShadow : ''}
          border-radius: ${euiTheme.border.radius.medium};
        }
      `
  }), [euiTheme.animation.normal, euiTheme.border.radius.medium, euiTheme.colors.lightShade, euiTheme.size.l, euiTheme.size.s, euiTheme.size.xl, imageShadow]);
  return customStyles;
};
exports.useStepContentStyles = useStepContentStyles;