"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAddIntegrationsCalloutStyles = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAddIntegrationsCalloutStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const backgroundColor = (0, _eui.useEuiBackgroundColor)('primary');
  const customStyles = (0, _react2.useMemo)(() => ({
    calloutWrapperStyles: (0, _react.css)`
        border-radius: ${euiTheme.border.radius.medium};
        border: 1px solid ${euiTheme.colors.lightShade};
        padding: ${euiTheme.size.xs} ${euiTheme.size.m};
        background-color: ${backgroundColor};
        margin-top: ${euiTheme.size.base};
      `,
    calloutTitleStyles: (0, _react.css)`
        color: ${euiTheme.colors.title};
        font-size: ${euiTheme.size.m};
        font-weight: ${euiTheme.font.weight.regular};
        line-height: ${euiTheme.base * 1.25}px;
        margin-left: ${euiTheme.size.xs};
      `,
    calloutAnchorStyles: (0, _react.css)`
        margin-left: ${euiTheme.size.s};
      `
  }), [backgroundColor, euiTheme.base, euiTheme.border.radius.medium, euiTheme.colors.lightShade, euiTheme.colors.title, euiTheme.font.weight.regular, euiTheme.size.base, euiTheme.size.m, euiTheme.size.s, euiTheme.size.xs]);
  return customStyles;
};
exports.useAddIntegrationsCalloutStyles = useAddIntegrationsCalloutStyles;