"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddElasticRulesButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _links = require("@kbn/security-solution-navigation/links");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _types = require("../types");
var _step_context = require("../context/step_context");
var _add_integration_callout = require("./add_integration_callout");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddElasticRulesButtonComponent = () => {
  var _finishedSteps$AddAnd;
  const {
    finishedSteps
  } = (0, _step_context.useStepContext)();
  const isIntegrationsStepComplete = (_finishedSteps$AddAnd = finishedSteps[_types.AddAndValidateYourDataCardsId.addIntegrations]) === null || _finishedSteps$AddAnd === void 0 ? void 0 : _finishedSteps$AddAnd.has(_types.AddIntegrationsSteps.connectToDataSources);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !isIntegrationsStepComplete && /*#__PURE__*/_react.default.createElement(_add_integration_callout.AddIntegrationCallout, {
    stepName: _translations.ADD_ELASTIC_RULES_CALLOUT_TITLE
  }), /*#__PURE__*/_react.default.createElement(_links.LinkButton, {
    id: _securitySolutionNavigation.SecurityPageName.rules,
    fill: true,
    className: "step-paragraph",
    disabled: !isIntegrationsStepComplete
  }, _translations.ADD_ELASTIC_RULES));
};
const AddElasticRulesButton = /*#__PURE__*/_react.default.memo(AddElasticRulesButtonComponent);
exports.AddElasticRulesButton = AddElasticRulesButton;