"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStepContext = exports.StepContextProvider = void 0;
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StepContext = /*#__PURE__*/_react.default.createContext(null);
const StepContextProvider = ({
  children,
  ...others
}) => {
  return /*#__PURE__*/_react.default.createElement(StepContext.Provider, {
    value: others
  }, children);
};
exports.StepContextProvider = StepContextProvider;
const useStepContext = () => {
  const context = _react.default.useContext(StepContext);
  if (!context) {
    throw new Error('useStepContext must be used within a StepContextProvider');
  }
  return context;
};
exports.useStepContext = useStepContext;