"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.copyTimelineRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _route_validation = require("../../../../../utils/build_validation/route_validation");
var _timeline = require("../../../../../../common/api/timeline");
var _timelines = require("../../../saved_object/timelines");
var _constants = require("../../../../../../common/constants");
var _utils = require("../../../../detection_engine/routes/utils");
var _common = require("../../../utils/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const copyTimelineRoute = async (router, _, security) => {
  router.versioned.post({
    path: _constants.TIMELINE_COPY_URL,
    options: {
      tags: ['access:securitySolution']
    },
    access: 'internal'
  }).addVersion({
    version: '1',
    validate: {
      request: {
        body: (0, _route_validation.buildRouteValidationWithExcess)(_timeline.copyTimelineSchema)
      }
    }
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      const frameworkRequest = await (0, _common.buildFrameworkRequest)(context, security, request);
      const {
        timeline,
        timelineIdToCopy
      } = request.body;
      const copiedTimeline = await (0, _timelines.copyTimeline)(frameworkRequest, timeline, timelineIdToCopy);
      return response.ok({
        body: {
          data: {
            persistTimeline: copiedTimeline
          }
        }
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return siemResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.copyTimelineRoute = copyTimelineRoute;