"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskScoreDataClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _server = require("@kbn/alerting-plugin/server");
var _common = require("@kbn/alerting-plugin/common");
var _configurations = require("./configurations");
var _create_datastream = require("../utils/create_datastream");
var _risk_engine_data_writer = require("./risk_engine_data_writer");
var _risk_engine = require("../../../../common/risk_engine");
var _transforms = require("../utils/transforms");
var _get_risk_inputs_index = require("./get_risk_inputs_index");
var _create_or_update_index = require("../utils/create_or_update_index");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class RiskScoreDataClient {
  constructor(options) {
    (0, _defineProperty2.default)(this, "writerCache", new Map());
    (0, _defineProperty2.default)(this, "getRiskInputsIndex", ({
      dataViewId
    }) => (0, _get_risk_inputs_index.getRiskInputsIndex)({
      dataViewId,
      logger: this.options.logger,
      soClient: this.options.soClient
    }));
    this.options = options;
  }
  async getWriter({
    namespace
  }) {
    if (this.writerCache.get(namespace)) {
      return this.writerCache.get(namespace);
    }
    const indexPatterns = (0, _configurations.getIndexPatternDataStream)(namespace);
    await this.initializeWriter(namespace, indexPatterns.alias);
    return this.writerCache.get(namespace);
  }
  async initializeWriter(namespace, index) {
    const writer = new _risk_engine_data_writer.RiskEngineDataWriter({
      esClient: this.options.esClient,
      namespace,
      index,
      logger: this.options.logger
    });
    this.writerCache.set(namespace, writer);
    return writer;
  }
  async init() {
    const namespace = this.options.namespace;
    try {
      const esClient = this.options.esClient;
      const indexPatterns = (0, _configurations.getIndexPatternDataStream)(namespace);
      const indexMetadata = {
        kibana: {
          version: this.options.kibanaVersion
        },
        managed: true,
        namespace
      };
      await Promise.all([(0, _server.createOrUpdateComponentTemplate)({
        logger: this.options.logger,
        esClient,
        template: {
          name: _configurations.mappingComponentName,
          _meta: {
            managed: true
          },
          template: {
            settings: {},
            mappings: (0, _common.mappingFromFieldMap)(_configurations.riskScoreFieldMap, 'strict')
          }
        },
        totalFieldsLimit: _configurations.totalFieldsLimit
      })]);
      await (0, _server.createOrUpdateIndexTemplate)({
        logger: this.options.logger,
        esClient,
        template: {
          name: indexPatterns.template,
          body: {
            data_stream: {
              hidden: true
            },
            index_patterns: [indexPatterns.alias],
            composed_of: [_configurations.mappingComponentName],
            template: {
              lifecycle: {},
              settings: {
                'index.mapping.total_fields.limit': _configurations.totalFieldsLimit
              },
              mappings: {
                dynamic: false,
                _meta: indexMetadata
              }
            },
            _meta: indexMetadata
          }
        }
      });
      await (0, _create_datastream.createDataStream)({
        logger: this.options.logger,
        esClient,
        totalFieldsLimit: _configurations.totalFieldsLimit,
        indexPatterns
      });
      await (0, _create_or_update_index.createOrUpdateIndex)({
        esClient,
        logger: this.options.logger,
        options: {
          index: (0, _risk_engine.getRiskScoreLatestIndex)(namespace),
          mappings: (0, _common.mappingFromFieldMap)(_configurations.riskScoreFieldMap, 'strict')
        }
      });
      const transformId = (0, _transforms.getLatestTransformId)(namespace);
      await (0, _transforms.createTransform)({
        esClient,
        logger: this.options.logger,
        transform: {
          transform_id: transformId,
          ...(0, _configurations.getTransformOptions)({
            dest: (0, _risk_engine.getRiskScoreLatestIndex)(namespace),
            source: [indexPatterns.alias]
          })
        }
      });
    } catch (error) {
      this.options.logger.error(`Error initializing risk engine resources: ${error.message}`);
      throw error;
    }
  }
}
exports.RiskScoreDataClient = RiskScoreDataClient;