"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskEngineDataWriter = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class RiskEngineDataWriter {
  constructor(options) {
    (0, _defineProperty2.default)(this, "bulk", async params => {
      try {
        var _params$host, _params$user;
        if (!((_params$host = params.host) !== null && _params$host !== void 0 && _params$host.length) && !((_params$user = params.user) !== null && _params$user !== void 0 && _params$user.length)) {
          return {
            errors: [],
            docs_written: 0,
            took: 0
          };
        }
        const {
          errors,
          items,
          took
        } = await this.options.esClient.bulk({
          operations: this.buildBulkOperations(params)
        });
        return {
          errors: errors ? items.map(item => {
            var _item$create, _item$create$error;
            return (_item$create = item.create) === null || _item$create === void 0 ? void 0 : (_item$create$error = _item$create.error) === null || _item$create$error === void 0 ? void 0 : _item$create$error.reason;
          }).filter(error => !!error) : [],
          docs_written: items.filter(item => {
            var _item$create2, _item$create3;
            return ((_item$create2 = item.create) === null || _item$create2 === void 0 ? void 0 : _item$create2.status) === 201 || ((_item$create3 = item.create) === null || _item$create3 === void 0 ? void 0 : _item$create3.status) === 200;
          }).length,
          took
        };
      } catch (e) {
        this.options.logger.error(`Error writing risk scores: ${e.message}`);
        return {
          errors: [`${e.message}`],
          docs_written: 0,
          took: 0
        };
      }
    });
    (0, _defineProperty2.default)(this, "buildBulkOperations", params => {
      var _params$host$flatMap, _params$host2, _params$user$flatMap, _params$user2;
      const hostBody = (_params$host$flatMap = (_params$host2 = params.host) === null || _params$host2 === void 0 ? void 0 : _params$host2.flatMap(score => [{
        create: {
          _index: this.options.index
        }
      }, this.scoreToEcs(score, 'host')])) !== null && _params$host$flatMap !== void 0 ? _params$host$flatMap : [];
      const userBody = (_params$user$flatMap = (_params$user2 = params.user) === null || _params$user2 === void 0 ? void 0 : _params$user2.flatMap(score => [{
        create: {
          _index: this.options.index
        }
      }, this.scoreToEcs(score, 'user')])) !== null && _params$user$flatMap !== void 0 ? _params$user$flatMap : [];
      return hostBody.concat(userBody);
    });
    (0, _defineProperty2.default)(this, "scoreToEcs", (score, identifierType) => {
      const {
        '@timestamp': _,
        ...rest
      } = score;
      return {
        '@timestamp': score['@timestamp'],
        [identifierType]: {
          name: score.id_value,
          risk: {
            ...rest
          }
        }
      };
    });
    this.options = options;
  }
}
exports.RiskEngineDataWriter = RiskEngineDataWriter;