"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateSavedObjectAttribute = exports.initSavedObjects = exports.getEnabledRiskEngineAmount = exports.getConfiguration = void 0;
var _risk_score_modules = require("../../../../../common/utils/risk_score_modules");
var _saved_object = require("../saved_object");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDefaultRiskEngineConfiguration = ({
  namespace
}) => ({
  dataViewId: (0, _risk_score_modules.getAlertsIndex)(namespace),
  enabled: false,
  filter: {},
  identifierType: undefined,
  interval: '1h',
  pageSize: 3_500,
  range: {
    start: 'now-30d',
    end: 'now'
  }
});
const getConfigurationSavedObject = async ({
  savedObjectsClient
}) => {
  var _savedObjectsResponse;
  const savedObjectsResponse = await savedObjectsClient.find({
    type: _saved_object.riskEngineConfigurationTypeName
  });
  return (_savedObjectsResponse = savedObjectsResponse.saved_objects) === null || _savedObjectsResponse === void 0 ? void 0 : _savedObjectsResponse[0];
};
const getEnabledRiskEngineAmount = async ({
  savedObjectsClient
}) => {
  var _savedObjectsResponse2, _savedObjectsResponse3;
  const savedObjectsResponse = await savedObjectsClient.find({
    type: _saved_object.riskEngineConfigurationTypeName,
    namespaces: ['*']
  });
  return (_savedObjectsResponse2 = savedObjectsResponse.saved_objects) === null || _savedObjectsResponse2 === void 0 ? void 0 : (_savedObjectsResponse3 = _savedObjectsResponse2.filter(config => {
    var _config$attributes;
    return config === null || config === void 0 ? void 0 : (_config$attributes = config.attributes) === null || _config$attributes === void 0 ? void 0 : _config$attributes.enabled;
  })) === null || _savedObjectsResponse3 === void 0 ? void 0 : _savedObjectsResponse3.length;
};
exports.getEnabledRiskEngineAmount = getEnabledRiskEngineAmount;
const updateSavedObjectAttribute = async ({
  savedObjectsClient,
  attributes
}) => {
  const savedObjectConfiguration = await getConfigurationSavedObject({
    savedObjectsClient
  });
  if (!savedObjectConfiguration) {
    throw new Error('Risk engine configuration not found');
  }
  const result = await savedObjectsClient.update(_saved_object.riskEngineConfigurationTypeName, savedObjectConfiguration.id, {
    ...attributes
  }, {
    refresh: 'wait_for'
  });
  return result;
};
exports.updateSavedObjectAttribute = updateSavedObjectAttribute;
const initSavedObjects = async ({
  namespace,
  savedObjectsClient
}) => {
  const configuration = await getConfigurationSavedObject({
    savedObjectsClient
  });
  if (configuration) {
    return configuration;
  }
  const result = await savedObjectsClient.create(_saved_object.riskEngineConfigurationTypeName, getDefaultRiskEngineConfiguration({
    namespace
  }), {});
  return result;
};
exports.initSavedObjects = initSavedObjects;
const getConfiguration = async ({
  savedObjectsClient
}) => {
  try {
    const savedObjectConfiguration = await getConfigurationSavedObject({
      savedObjectsClient
    });
    const configuration = savedObjectConfiguration === null || savedObjectConfiguration === void 0 ? void 0 : savedObjectConfiguration.attributes;
    if (configuration) {
      return configuration;
    }
    return null;
  } catch (e) {
    return null;
  }
};
exports.getConfiguration = getConfiguration;