"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.wrapSuppressedThresholdALerts = void 0;
var _objectHash = _interopRequireDefault(require("object-hash"));
var _sortBy = _interopRequireDefault(require("lodash/sortBy"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _build_bulk_body = require("../factories/utils/build_bulk_body");
var _bulk_create_threshold_signals = require("./bulk_create_threshold_signals");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * wraps suppressed threshold alerts
 * first, transforms aggregation threshold buckets to hits
 * creates instanceId hash, which is used to search suppressed on time interval alerts
 * populates alert's suppression fields
 */
const wrapSuppressedThresholdALerts = ({
  buckets,
  spaceId,
  completeRule,
  mergeStrategy,
  indicesToQuery,
  buildReasonMessage,
  alertTimestampOverride,
  ruleExecutionLogger,
  publicBaseUrl,
  inputIndex,
  startedAt,
  from,
  to,
  threshold
}) => {
  return buckets.map(bucket => {
    const hit = (0, _bulk_create_threshold_signals.transformBucketIntoHit)(bucket, inputIndex, startedAt, from, threshold, completeRule.ruleParams.ruleId);
    const suppressedValues = (0, _sortBy.default)(Object.entries(bucket.key).map(([_, value]) => value));
    const id = (0, _objectHash.default)([hit._index, hit._id, `${spaceId}:${completeRule.alertId}`, suppressedValues]);
    const instanceId = (0, _objectHash.default)([suppressedValues, completeRule.alertId, spaceId]);
    const baseAlert = (0, _build_bulk_body.buildBulkBody)(spaceId, completeRule, hit, mergeStrategy, [], true, buildReasonMessage, indicesToQuery, alertTimestampOverride, ruleExecutionLogger, id, publicBaseUrl);
    // suppression start/end equals to alert timestamp, since we suppress alerts for threshold rule type, not documents as for query rule type
    const suppressionTime = new Date(baseAlert[_ruleDataUtils.TIMESTAMP]);
    return {
      _id: id,
      _index: '',
      _source: {
        ...baseAlert,
        [_ruleDataUtils.ALERT_SUPPRESSION_TERMS]: Object.entries(bucket.key).map(([field, value]) => ({
          field,
          value
        })),
        [_ruleDataUtils.ALERT_SUPPRESSION_START]: suppressionTime,
        [_ruleDataUtils.ALERT_SUPPRESSION_END]: suppressionTime,
        [_ruleDataUtils.ALERT_SUPPRESSION_DOCS_COUNT]: 0,
        [_ruleDataUtils.ALERT_INSTANCE_ID]: instanceId
      }
    };
  });
};
exports.wrapSuppressedThresholdALerts = wrapSuppressedThresholdALerts;