"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.endpointResponseAction = void 0;
var _lodash = require("lodash");
var _ruleDataUtils = require("@kbn/rule-data-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const endpointResponseAction = (responseAction, endpointAppContextService, {
  alerts
}) => {
  const {
    comment,
    command
  } = responseAction.params;
  const commonData = {
    comment,
    command,
    rule_id: alerts[0][_ruleDataUtils.ALERT_RULE_UUID],
    rule_name: alerts[0][_ruleDataUtils.ALERT_RULE_NAME]
  };
  const agentIds = (0, _lodash.uniq)((0, _lodash.map)(alerts, 'agent.id'));
  const alertIds = (0, _lodash.map)(alerts, '_id');
  const hosts = alerts.reduce((acc, alert) => {
    var _alert$agent;
    if ((_alert$agent = alert.agent) !== null && _alert$agent !== void 0 && _alert$agent.name && !acc[alert.agent.id]) {
      acc[alert.agent.id] = alert.agent.name;
    }
    return acc;
  }, {});
  return Promise.all((0, _lodash.each)(agentIds, async agent => endpointAppContextService.getActionCreateService().createActionFromAlert({
    hosts: {
      [agent]: {
        name: hosts[agent]
      }
    },
    endpoint_ids: [agent],
    alert_ids: alertIds,
    ...commonData
  }, [agent])));
};
exports.endpointResponseAction = endpointResponseAction;