"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.normalizeRuleHealthAggregationResult = exports.getRuleHealthAggregation = void 0;
var f = _interopRequireWildcard(require("../../../event_log/event_log_fields"));
var _rule_execution_stats = require("./rule_execution_stats");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getRuleHealthAggregation = granularity => {
  // Let's say we want to calculate rule execution statistics over some date interval, where:
  //   - the whole interval is one week (7 days)
  //   - the interval's granularity is one day
  // This means we will be calculating the same rule execution stats:
  //   - One time over the whole week.
  //   - Seven times over a day, per each day in the week.
  return {
    // And so this function creates several aggs that will be calculated for the whole interval.
    ...(0, _rule_execution_stats.getRuleExecutionStatsAggregation)('whole-interval'),
    // And this one creates a histogram, where for each bucket we will calculate the same aggs.
    // The histogram's "calendar_interval" is equal to the granularity parameter.
    ...getRuleExecutionStatsHistoryAggregation(granularity)
  };
};
exports.getRuleHealthAggregation = getRuleHealthAggregation;
const getRuleExecutionStatsHistoryAggregation = granularity => {
  return {
    statsHistory: {
      date_histogram: {
        field: f.TIMESTAMP,
        calendar_interval: granularity
      },
      aggs: (0, _rule_execution_stats.getRuleExecutionStatsAggregation)('histogram')
    }
  };
};
const normalizeRuleHealthAggregationResult = (result, requestAggs) => {
  var _result$aggregations;
  const aggregations = (_result$aggregations = result.aggregations) !== null && _result$aggregations !== void 0 ? _result$aggregations : {};
  return {
    stats_over_interval: (0, _rule_execution_stats.normalizeRuleExecutionStatsAggregationResult)(aggregations, 'whole-interval'),
    history_over_interval: normalizeHistoryOverInterval(aggregations),
    debug: {
      eventLog: {
        request: {
          aggs: requestAggs
        },
        response: {
          aggregations
        }
      }
    }
  };
};
exports.normalizeRuleHealthAggregationResult = normalizeRuleHealthAggregationResult;
const normalizeHistoryOverInterval = aggregations => {
  const statsHistory = aggregations.statsHistory || {};
  return {
    buckets: statsHistory.buckets.map(rawBucket => {
      const timestamp = String(rawBucket.key_as_string);
      const stats = (0, _rule_execution_stats.normalizeRuleExecutionStatsAggregationResult)(rawBucket, 'histogram');
      return {
        timestamp,
        stats
      };
    })
  };
};