"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bulkDeleteRulesRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _rule_management = require("../../../../../../../common/api/detection_engine/rule_management");
var _constants = require("../../../../../../../common/constants");
var _route_validation = require("../../../../../../utils/build_validation/route_validation");
var _utils = require("../../../../routes/utils");
var _delete_rules = require("../../../logic/crud/delete_rules");
var _read_rules = require("../../../logic/crud/read_rules");
var _utils2 = require("../../../utils/utils");
var _validate = require("../../../utils/validate");
var _deprecation = require("../../deprecation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * @deprecated since version 8.2.0. Use the detection_engine/rules/_bulk_action API instead
 */
const bulkDeleteRulesRoute = (router, logger) => {
  const handler = async (context, request, response) => {
    (0, _deprecation.logDeprecatedBulkEndpoint)(logger, _constants.DETECTION_ENGINE_RULES_BULK_DELETE);
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      const ctx = await context.resolve(['core', 'securitySolution', 'alerting']);
      const rulesClient = ctx.alerting.getRulesClient();
      const rules = await Promise.all(request.body.map(async payloadRule => {
        var _ref;
        const {
          id,
          rule_id: ruleId
        } = payloadRule;
        const idOrRuleIdOrUnknown = (_ref = id !== null && id !== void 0 ? id : ruleId) !== null && _ref !== void 0 ? _ref : '(unknown id)';
        const validationErrors = (0, _rule_management.validateQueryRuleByIds)(payloadRule);
        if (validationErrors.length) {
          return (0, _utils.createBulkErrorObject)({
            ruleId: idOrRuleIdOrUnknown,
            statusCode: 400,
            message: validationErrors.join()
          });
        }
        try {
          const rule = await (0, _read_rules.readRules)({
            rulesClient,
            id,
            ruleId
          });
          if (!rule) {
            return (0, _utils2.getIdBulkError)({
              id,
              ruleId
            });
          }
          await (0, _delete_rules.deleteRules)({
            ruleId: rule.id,
            rulesClient
          });
          return (0, _validate.transformValidateBulkError)(idOrRuleIdOrUnknown, rule);
        } catch (err) {
          return (0, _utils.transformBulkError)(idOrRuleIdOrUnknown, err);
        }
      }));
      return response.ok({
        body: _rule_management.BulkCrudRulesResponse.parse(rules),
        headers: (0, _deprecation.getDeprecatedBulkEndpointHeader)(_constants.DETECTION_ENGINE_RULES_BULK_DELETE)
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return siemResponse.error({
        body: error.message,
        headers: (0, _deprecation.getDeprecatedBulkEndpointHeader)(_constants.DETECTION_ENGINE_RULES_BULK_DELETE),
        statusCode: error.statusCode
      });
    }
  };
  const routeConfig = {
    access: 'public',
    path: _constants.DETECTION_ENGINE_RULES_BULK_DELETE,
    options: {
      tags: ['access:securitySolution']
    }
  };
  const versionConfig = {
    version: '2023-10-31',
    validate: {
      request: {
        body: (0, _route_validation.buildRouteValidationWithZod)(_rule_management.BulkDeleteRulesRequestBody)
      }
    }
  };
  router.versioned.delete(routeConfig).addVersion(versionConfig, handler);
  router.versioned.post(routeConfig).addVersion(versionConfig, handler);
};
exports.bulkDeleteRulesRoute = bulkDeleteRulesRoute;