"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ensureLatestRulesPackageInstalled = ensureLatestRulesPackageInstalled;
var _install_prebuilt_rules_package = require("../api/install_prebuilt_rules_and_timelines/install_prebuilt_rules_package");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function ensureLatestRulesPackageInstalled(ruleAssetsClient, config, securityContext) {
  let latestPrebuiltRules = await ruleAssetsClient.fetchLatestAssets();
  if (latestPrebuiltRules.length === 0) {
    // Seems no packages with prepackaged rules were installed, try to install the default rules package
    await (0, _install_prebuilt_rules_package.installPrebuiltRulesPackage)(config, securityContext);

    // Try to get the prepackaged rules again
    latestPrebuiltRules = await ruleAssetsClient.fetchLatestAssets();
  }
  return latestPrebuiltRules;
}