"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.calculateFieldsDiffFor = void 0;
var _lodash = require("lodash");
var _prebuilt_rules = require("../../../../../../../common/api/detection_engine/prebuilt_rules");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const calculateFieldsDiffFor = (ruleVersions, fieldsDiffAlgorithms) => {
  const result = (0, _lodash.mapValues)(fieldsDiffAlgorithms, (calculateFieldDiff, fieldName) => {
    const fieldVersions = pickField(fieldName, ruleVersions);
    const fieldDiff = calculateFieldDiff(fieldVersions);
    return fieldDiff;
  });

  // TODO: try to improve strict typing and get rid of this "as" operator.
  return result;
};
exports.calculateFieldsDiffFor = calculateFieldsDiffFor;
const pickField = (fieldName, versions) => {
  return {
    base_version: versions.base_version !== _prebuilt_rules.MissingVersion ? versions.base_version[fieldName] : _prebuilt_rules.MissingVersion,
    current_version: versions.current_version[fieldName],
    target_version: versions.target_version[fieldName]
  };
};