"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.reviewRuleInstallationRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _prebuilt_rules = require("../../../../../../common/api/detection_engine/prebuilt_rules");
var _utils = require("../../../routes/utils");
var _prebuilt_rule_assets_client = require("../../logic/rule_assets/prebuilt_rule_assets_client");
var _prebuilt_rule_objects_client = require("../../logic/rule_objects/prebuilt_rule_objects_client");
var _fetch_rule_versions_triad = require("../../logic/rule_versions/fetch_rule_versions_triad");
var _get_version_buckets = require("../../model/rule_versions/get_version_buckets");
var _rule_converters = require("../../../rule_management/normalization/rule_converters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const reviewRuleInstallationRoute = router => {
  router.versioned.post({
    access: 'internal',
    path: _prebuilt_rules.REVIEW_RULE_INSTALLATION_URL,
    options: {
      tags: ['access:securitySolution']
    }
  }).addVersion({
    version: '1',
    validate: {}
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      const ctx = await context.resolve(['core', 'alerting']);
      const soClient = ctx.core.savedObjects.client;
      const rulesClient = ctx.alerting.getRulesClient();
      const ruleAssetsClient = (0, _prebuilt_rule_assets_client.createPrebuiltRuleAssetsClient)(soClient);
      const ruleObjectsClient = (0, _prebuilt_rule_objects_client.createPrebuiltRuleObjectsClient)(rulesClient);
      const ruleVersionsMap = await (0, _fetch_rule_versions_triad.fetchRuleVersionsTriad)({
        ruleAssetsClient,
        ruleObjectsClient
      });
      const {
        installableRules
      } = (0, _get_version_buckets.getVersionBuckets)(ruleVersionsMap);
      const body = {
        stats: calculateRuleStats(installableRules),
        rules: installableRules.map(prebuiltRuleAsset => (0, _rule_converters.convertPrebuiltRuleAssetToRuleResponse)(prebuiltRuleAsset))
      };
      return response.ok({
        body
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return siemResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.reviewRuleInstallationRoute = reviewRuleInstallationRoute;
const getAggregatedTags = rules => {
  const set = new Set(rules.flatMap(rule => rule.tags || []));
  return Array.from(set.values()).sort((a, b) => a.localeCompare(b));
};
const calculateRuleStats = rulesToInstall => {
  const tagsOfRulesToInstall = getAggregatedTags(rulesToInstall);
  return {
    num_rules_to_install: rulesToInstall.length,
    tags: tagsOfRulesToInstall
  };
};