"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createTimelineChangedEpic = void 0;
var _fp = require("lodash/fp");
var _operators = require("rxjs/operators");
var _actions = require("./actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * All action types that will mark a timeline as changed
 */
const timelineChangedTypes = new Set([_actions.applyKqlFilterQuery.type, _actions.addProvider.type, _actions.dataProviderEdited.type, _actions.removeProvider.type, _actions.setExcludedRowRendererIds.type, _actions.setFilters.type, _actions.setSavedQueryId.type, _actions.updateDataProviderEnabled.type, _actions.updateDataProviderExcluded.type, _actions.updateDataProviderType.type, _actions.updateEqlOptions.type, _actions.updateKqlMode.type, _actions.updateProviders.type, _actions.updateTitleAndDescription.type, _actions.updateDataView.type, _actions.removeColumn.type, _actions.updateColumns.type, _actions.updateSort.type, _actions.updateRange.type, _actions.upsertColumn.type, _actions.updateSavedSearch.type]);

/**
 * Maps actions that mark a timeline change to `setChanged` actions.
 * This allows to detect unsaved timeline changes when navigating away from the timeline.
 */
const createTimelineChangedEpic = () => action$ => {
  return action$.pipe(
  // Only apply mapping to some actions
  (0, _operators.filter)(action => timelineChangedTypes.has(action.type)),
  // Map the action to a `changed` action
  (0, _operators.map)(action => (0, _actions.setChanged)({
    id: (0, _fp.get)('payload.id', action),
    changed: true
  })));
};
exports.createTimelineChangedEpic = createTimelineChangedEpic;