"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTimelineDataFilters = useTimelineDataFilters;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _use_selector = require("../../common/hooks/use_selector");
var _selectors = require("../../common/components/super_date_picker/selectors");
var _model = require("../../common/store/sourcerer/model");
var _sourcerer = require("../../common/containers/sourcerer");
var _store = require("../../common/store");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useTimelineDataFilters(isActiveTimelines) {
  const getStartSelector = (0, _react.useMemo)(() => (0, _selectors.startSelector)(), []);
  const getEndSelector = (0, _react.useMemo)(() => (0, _selectors.endSelector)(), []);
  const getIsLoadingSelector = (0, _react.useMemo)(() => (0, _selectors.isLoadingSelector)(), []);
  const shouldUpdate = (0, _use_selector.useDeepEqualSelector)(state => {
    if (isActiveTimelines) {
      return getIsLoadingSelector(state.inputs.timeline);
    } else {
      return getIsLoadingSelector(state.inputs.global);
    }
  });
  const from = (0, _use_selector.useDeepEqualSelector)(state => {
    if (isActiveTimelines) {
      return getStartSelector(state.inputs.timeline);
    } else {
      return getStartSelector(state.inputs.global);
    }
  });
  const to = (0, _use_selector.useDeepEqualSelector)(state => {
    if (isActiveTimelines) {
      return getEndSelector(state.inputs.timeline);
    } else {
      return getEndSelector(state.inputs.global);
    }
  });
  const getDefaultDataViewSelector = (0, _react.useMemo)(() => _store.sourcererSelectors.defaultDataViewSelector(), []);
  const defaultDataView = (0, _use_selector.useDeepEqualSelector)(getDefaultDataViewSelector);
  const {
    pathname
  } = (0, _reactRouterDom.useLocation)();
  const {
    selectedPatterns: nonTimelinePatterns
  } = (0, _sourcerer.useSourcererDataView)((0, _sourcerer.getScopeFromPath)(pathname));
  const {
    selectedPatterns: timelinePatterns
  } = (0, _sourcerer.useSourcererDataView)(_model.SourcererScopeName.timeline);
  const selectedPatterns = (0, _react.useMemo)(() => {
    return isActiveTimelines ? [...new Set([...timelinePatterns, ...defaultDataView.patternList])] : [...new Set([...nonTimelinePatterns, ...defaultDataView.patternList])];
  }, [isActiveTimelines, timelinePatterns, nonTimelinePatterns, defaultDataView.patternList]);
  return {
    selectedPatterns,
    from,
    to,
    shouldUpdate
  };
}