"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.skipQueryForDetectionsPage = exports.getTimelineQueryTypes = exports.detectionsTimelineIds = void 0;
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTimelineQueryTypes = timeline => ({
  hasQuery: timeline.kqlQuery != null && timeline.kqlQuery.filterQuery != null && timeline.kqlQuery.filterQuery.kuery != null && timeline.kqlQuery.filterQuery.kuery.expression !== '' || timeline.dataProviders != null && timeline.dataProviders.length > 0 || timeline.filters != null && timeline.filters.length > 0,
  hasEql: timeline.eqlOptions != null && timeline.eqlOptions.query != null && timeline.eqlOptions.query.length > 0
});
exports.getTimelineQueryTypes = getTimelineQueryTypes;
const detectionsTimelineIds = [_securitysolutionDataTable.TableId.alertsOnAlertsPage, _securitysolutionDataTable.TableId.alertsOnRuleDetailsPage];
exports.detectionsTimelineIds = detectionsTimelineIds;
const skipQueryForDetectionsPage = (id, defaultIndex, useRuleRegistry = false) => id != null && detectionsTimelineIds.some(timelineId => timelineId === id) && !defaultIndex.some(di => di.toLowerCase().startsWith(useRuleRegistry ? _constants.DEFAULT_ALERTS_INDEX : '.siem-signals'));
exports.skipQueryForDetectionsPage = skipQueryForDetectionsPage;