"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchTimelineSuperSelect = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _selectable_timeline = require("../selectable_timeline");
var i18n = _interopRequireWildcard(require("../translations"));
var _timeline = require("../../../../../common/api/timeline");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledEuiInputPopover = (0, _styledComponents.default)(_eui.EuiInputPopover)`
  .rightArrowIcon {
    .euiFieldText {
      padding-left: 12px;
      padding-right: 40px;

      &[readonly] {
        cursor: pointer;
        background-size: 0 100%;
        background-repeat: no-repeat;

        // To match EuiFieldText focus state
        &:focus {
          background-color: ${({
  theme
}) => theme.eui.euiFormBackgroundColor};
          background-image: linear-gradient(
            to top,
            ${({
  theme
}) => theme.eui.euiFocusRingColor},
            ${({
  theme
}) => theme.eui.euiFocusRingColor} 2px,
            transparent 2px,
            transparent 100%
          );
          background-size: 100% 100%;
        }
      }
    }
    .euiFormControlLayoutIcons {
      left: unset;
      right: 12px;
    }
  }
`;
const getBasicSelectableOptions = timelineId => [{
  description: i18n.DEFAULT_TIMELINE_DESCRIPTION,
  favorite: [],
  label: i18n.DEFAULT_TIMELINE_TITLE,
  id: undefined,
  title: i18n.DEFAULT_TIMELINE_TITLE,
  checked: timelineId === '-1' ? 'on' : undefined
}];
const SearchTimelineSuperSelectComponent = ({
  isDisabled,
  hideUntitled = false,
  timelineId,
  timelineTitle,
  timelineType = _timeline.TimelineType.template,
  onTimelineChange,
  placeholder
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const handleClosePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(false);
  }, []);
  const handleOpenPopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(true);
  }, []);
  const superSelect = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    readOnly: true,
    disabled: isDisabled,
    onFocus: handleOpenPopover,
    onClick: handleOpenPopover,
    value: timelineTitle !== null && timelineTitle !== void 0 ? timelineTitle : i18n.DEFAULT_TIMELINE_TITLE,
    icon: "arrowDown"
  }), [handleOpenPopover, isDisabled, timelineTitle]);
  const handleGetSelectableOptions = (0, _react.useCallback)(({
    timelines,
    onlyFavorites,
    searchTimelineValue
  }) => [...(!onlyFavorites && searchTimelineValue === '' ? getBasicSelectableOptions(timelineId == null ? '-1' : timelineId) : []), ...timelines.filter(t => !hideUntitled || t.title !== '').map((t, index) => ({
    description: t.description,
    favorite: t.favorite,
    label: t.title,
    id: timelineType === _timeline.TimelineType.template ? t.templateTimelineId : t.savedObjectId,
    key: `${t.title}-${index}`,
    title: t.title,
    checked: [t.savedObjectId, t.templateTimelineId].includes(timelineId) ? 'on' : undefined
  }))], [hideUntitled, timelineId, timelineType]);
  return /*#__PURE__*/_react.default.createElement(StyledEuiInputPopover, {
    id: "searchTimelinePopover",
    input: superSelect,
    isOpen: isPopoverOpen,
    closePopover: handleClosePopover,
    anchorClassName: "rightArrowIcon"
  }, /*#__PURE__*/_react.default.createElement(_selectable_timeline.SelectableTimeline, {
    hideUntitled: hideUntitled,
    getSelectableOptions: handleGetSelectableOptions,
    onClosePopover: handleClosePopover,
    onTimelineChange: onTimelineChange,
    timelineType: timelineType,
    placeholder: placeholder
  }));
};
const SearchTimelineSuperSelect = /*#__PURE__*/(0, _react.memo)(SearchTimelineSuperSelectComponent);
exports.SearchTimelineSuperSelect = SearchTimelineSuperSelect;