"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProviderItemBadge = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _timeline = require("../../../../../common/api/timeline");
var _use_selector = require("../../../../common/hooks/use_selector");
var _timeline2 = require("../../../store/timeline");
var _provider_badge = require("./provider_badge");
var _provider_item_actions = require("./provider_item_actions");
var _data_provider = require("./data_provider");
var _drag_and_drop = require("../../../../common/store/drag_and_drop");
var _defaults = require("../../../store/timeline/defaults");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ProviderItemBadge = /*#__PURE__*/_react.default.memo(({
  andProviderId,
  browserFields,
  deleteProvider,
  field,
  kqlQuery,
  isEnabled,
  isExcluded,
  isPopoverOpen,
  onDataProviderEdited,
  operator,
  providerId,
  register,
  setIsPopoverOpen,
  timelineId,
  toggleEnabledProvider,
  toggleExcludedProvider,
  toggleTypeProvider,
  displayValue,
  val,
  type = _data_provider.DataProviderType.default,
  wrapperRef
}) => {
  const getTimeline = (0, _react.useMemo)(() => _timeline2.timelineSelectors.getTimelineByIdSelector(), []);
  const timelineType = (0, _use_selector.useShallowEqualSelector)(state => {
    var _getTimeline$timeline, _getTimeline;
    if (!timelineId) {
      return _timeline.TimelineType.default;
    }
    return (_getTimeline$timeline = (_getTimeline = getTimeline(state, timelineId)) === null || _getTimeline === void 0 ? void 0 : _getTimeline.timelineType) !== null && _getTimeline$timeline !== void 0 ? _getTimeline$timeline : _timeline.TimelineType.default;
  });
  const {
    isLoading
  } = (0, _use_selector.useDeepEqualSelector)(state => {
    var _getTimeline2;
    return (_getTimeline2 = getTimeline(state, timelineId !== null && timelineId !== void 0 ? timelineId : '')) !== null && _getTimeline2 !== void 0 ? _getTimeline2 : _defaults.timelineDefaults;
  });
  const togglePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(!isPopoverOpen);
  }, [isPopoverOpen, setIsPopoverOpen]);
  const closePopover = (0, _react.useCallback)(() => {
    var _wrapperRef$current;
    setIsPopoverOpen(false);
    wrapperRef === null || wrapperRef === void 0 ? void 0 : (_wrapperRef$current = wrapperRef.current) === null || _wrapperRef$current === void 0 ? void 0 : _wrapperRef$current.focus();
  }, [wrapperRef, setIsPopoverOpen]);
  const onToggleEnabledProvider = (0, _react.useCallback)(() => {
    toggleEnabledProvider();
    closePopover();
  }, [closePopover, toggleEnabledProvider]);
  const onToggleExcludedProvider = (0, _react.useCallback)(() => {
    toggleExcludedProvider();
    closePopover();
  }, [toggleExcludedProvider, closePopover]);
  const onToggleTypeProvider = (0, _react.useCallback)(() => {
    toggleTypeProvider();
    closePopover();
  }, [toggleTypeProvider, closePopover]);
  const [providerRegistered, setProviderRegistered] = (0, _react.useState)(false);
  const dispatch = (0, _reactRedux.useDispatch)();
  (0, _react.useEffect)(() => {
    // optionally register the provider if provided
    if (register != null) {
      dispatch(_drag_and_drop.dragAndDropActions.registerProvider({
        provider: {
          ...register,
          and: []
        }
      }));
      setProviderRegistered(true);
    }
  }, [providerRegistered, dispatch, register, setProviderRegistered]);
  const unRegisterProvider = (0, _react.useCallback)(() => {
    if (providerRegistered && register != null) {
      dispatch(_drag_and_drop.dragAndDropActions.unRegisterProvider({
        id: register.id
      }));
    }
  }, [providerRegistered, dispatch, register]);
  (0, _react.useEffect)(() => () => {
    unRegisterProvider();
  }, [unRegisterProvider]);
  const button = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_provider_badge.ProviderBadge, {
    deleteProvider: !isLoading ? deleteProvider : _fp.noop,
    field: field,
    kqlQuery: kqlQuery,
    isEnabled: isEnabled,
    isExcluded: isExcluded,
    providerId: providerId,
    togglePopover: togglePopover,
    toggleType: onToggleTypeProvider,
    displayValue: displayValue !== null && displayValue !== void 0 ? displayValue : String(val),
    val: val,
    operator: operator,
    type: type,
    timelineType: timelineType
  }), [deleteProvider, displayValue, field, isEnabled, isExcluded, isLoading, kqlQuery, onToggleTypeProvider, operator, providerId, timelineType, togglePopover, type, val]);
  return /*#__PURE__*/_react.default.createElement(_provider_item_actions.ProviderItemActions, {
    andProviderId: andProviderId,
    browserFields: browserFields,
    button: button,
    closePopover: closePopover,
    deleteProvider: deleteProvider,
    field: field,
    kqlQuery: kqlQuery,
    isEnabled: isEnabled,
    isExcluded: isExcluded,
    isLoading: isLoading,
    isOpen: isPopoverOpen,
    onDataProviderEdited: onDataProviderEdited,
    operator: operator,
    providerId: providerId,
    timelineId: timelineId,
    timelineType: timelineType,
    toggleEnabledProvider: onToggleEnabledProvider,
    toggleExcludedProvider: onToggleExcludedProvider,
    toggleTypeProvider: onToggleTypeProvider,
    value: val,
    type: type
  });
});
exports.ProviderItemBadge = ProviderItemBadge;
ProviderItemBadge.displayName = 'ProviderItemBadge';