"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLinksFromSignature = exports.getBeginningTokens = void 0;
var _fp = require("lodash/fp");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const lazySuricataLibConfiguration = () => {
  /**
   * The specially formatted comment in the `import` expression causes the corresponding webpack chunk to be named. This aids us in debugging chunk size issues.
   * See https://webpack.js.org/api/module-methods/#magic-comments
   */
  return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "lazy_suricata_lib_configuration" */
  'suricata-sid-db')));
};
const has = (obj, key) => Object.prototype.hasOwnProperty.call(obj, key);
const getLinksFromSignature = async id => {
  const db = (await lazySuricataLibConfiguration()).db;
  const refs = has(db, id) ? db[id] : null;
  if (refs != null) {
    return (0, _fp.uniq)(refs);
  } else {
    return [];
  }
};
exports.getLinksFromSignature = getLinksFromSignature;
const specialTokenRules = ['IPv4', 'IPv6'];
const getBeginningTokens = signature => {
  const signatureSplit = signature.trim().split(' ');
  return signatureSplit.reduce((accum, curr, index) => {
    if (accum.length === index && curr === curr.toUpperCase() && curr !== '' || specialTokenRules.includes(curr)) {
      return [...accum, curr];
    }
    return accum;
  }, []);
};
exports.getBeginningTokens = getBeginningTokens;