"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Bytes = exports.BYTES_FORMAT = void 0;
var _react = _interopRequireDefault(require("react"));
var _draggables = require("../../../../../../common/components/draggables");
var _formatted_bytes = require("../../../../../../common/components/formatted_bytes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BYTES_FORMAT = 'bytes';

/**
 * Renders draggable text containing the value of a field representing a
 * duration of time, (e.g. `event.duration`)
 */
exports.BYTES_FORMAT = BYTES_FORMAT;
const Bytes = /*#__PURE__*/_react.default.memo(({
  contextId,
  eventId,
  fieldName,
  fieldType,
  isAggregatable,
  isDraggable,
  value,
  scopeId
}) => isDraggable ? /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
  id: `bytes-default-draggable-${contextId}-${eventId}-${fieldName}-${value}`,
  fieldType: fieldType,
  isAggregatable: isAggregatable,
  isDraggable: isDraggable
  // @ts-expect-error
  ,
  name: name,
  field: fieldName,
  tooltipContent: null,
  value: value,
  scopeId: scopeId
}, /*#__PURE__*/_react.default.createElement(_formatted_bytes.PreferenceFormattedBytes, {
  value: `${value}`
})) : /*#__PURE__*/_react.default.createElement(_formatted_bytes.PreferenceFormattedBytes, {
  value: `${value}`
}));
exports.Bytes = Bytes;
Bytes.displayName = 'Bytes';