"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatefulEvent = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _use_selector = require("../../../../../common/hooks/use_selector");
var _timeline = require("../../../../../../common/types/timeline");
var _helpers = require("../../helpers");
var _styles = require("../../styles");
var _helpers2 = require("../helpers");
var _note_cards = require("../../../notes/note_cards");
var _event_details_width_context = require("../../../../../common/components/events_viewer/event_details_width_context");
var _event_column_view = require("./event_column_view");
var _store = require("../../../../../common/store");
var _timeline2 = require("../../../../store/timeline");
var _active_timeline_context = require("../../../../containers/active_timeline_context");
var _get_row_renderer = require("../renderers/get_row_renderer");
var _stateful_row_renderer = require("./stateful_row_renderer");
var _helpers3 = require("../../properties/helpers");
var _defaults = require("../../../../store/timeline/defaults");
var _data_driven_columns = require("../data_driven_columns");
var _stateful_event_context = require("../../../../../common/components/events_viewer/stateful_event_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const emptyNotes = [];
const EventsTrSupplementContainerWrapper = /*#__PURE__*/_react.default.memo(({
  children
}) => {
  const width = (0, _event_details_width_context.useEventDetailsWidthContext)();
  return /*#__PURE__*/_react.default.createElement(_styles.EventsTrSupplementContainer, {
    width: width
  }, children);
});
EventsTrSupplementContainerWrapper.displayName = 'EventsTrSupplementContainerWrapper';
const StatefulEventComponent = ({
  actionsColumnWidth,
  containerRef,
  columnHeaders,
  event,
  eventIdToNoteIds,
  isEventViewer = false,
  isEventPinned = false,
  lastFocusedAriaColindex,
  loadingEventIds,
  onRowSelected,
  refetch,
  renderCellValue,
  rowRenderers,
  onRuleChange,
  ariaRowindex,
  selectedEventIds,
  showCheckboxes,
  tabType,
  timelineId,
  leadingControlColumns,
  trailingControlColumns
}) => {
  var _activeExpandedDetail, _activeExpandedDetail2, _activeExpandedDetail3, _activeExpandedDetail4;
  const trGroupRef = (0, _react.useRef)(null);
  const dispatch = (0, _reactRedux.useDispatch)();
  // Store context in state rather than creating object in provider value={} to prevent re-renders caused by a new object being created
  const [activeStatefulEventContext] = (0, _react.useState)({
    timelineID: timelineId,
    enableHostDetailsFlyout: true,
    enableIpDetailsFlyout: true,
    tabType
  });
  const [showNotes, setShowNotes] = (0, _react.useState)({});
  const getTimeline = (0, _react.useMemo)(() => _timeline2.timelineSelectors.getTimelineByIdSelector(), []);
  const expandedDetail = (0, _use_selector.useDeepEqualSelector)(state => {
    var _expandedDetail, _getTimeline;
    return (_expandedDetail = ((_getTimeline = getTimeline(state, timelineId)) !== null && _getTimeline !== void 0 ? _getTimeline : _defaults.timelineDefaults).expandedDetail) !== null && _expandedDetail !== void 0 ? _expandedDetail : {};
  });
  const hostNameArr = (0, _data_driven_columns.useGetMappedNonEcsValue)({
    data: event === null || event === void 0 ? void 0 : event.data,
    fieldName: 'host.name'
  });
  const hostName = (0, _react.useMemo)(() => {
    return hostNameArr && hostNameArr.length > 0 ? hostNameArr[0] : null;
  }, [hostNameArr]);
  const hostIpList = (0, _data_driven_columns.useGetMappedNonEcsValue)({
    data: event === null || event === void 0 ? void 0 : event.data,
    fieldName: 'host.ip'
  });
  const sourceIpList = (0, _data_driven_columns.useGetMappedNonEcsValue)({
    data: event === null || event === void 0 ? void 0 : event.data,
    fieldName: 'source.ip'
  });
  const destinationIpList = (0, _data_driven_columns.useGetMappedNonEcsValue)({
    data: event === null || event === void 0 ? void 0 : event.data,
    fieldName: 'destination.ip'
  });
  const hostIPAddresses = (0, _react.useMemo)(() => {
    const hostIps = hostIpList !== null && hostIpList !== void 0 ? hostIpList : [];
    const sourceIps = sourceIpList !== null && sourceIpList !== void 0 ? sourceIpList : [];
    const destinationIps = destinationIpList !== null && destinationIpList !== void 0 ? destinationIpList : [];
    return new Set([...hostIps, ...sourceIps, ...destinationIps]);
  }, [destinationIpList, sourceIpList, hostIpList]);
  const activeTab = tabType !== null && tabType !== void 0 ? tabType : _timeline.TimelineTabs.query;
  const activeExpandedDetail = expandedDetail[activeTab];
  const isDetailPanelExpanded = (activeExpandedDetail === null || activeExpandedDetail === void 0 ? void 0 : activeExpandedDetail.panelView) === 'eventDetail' && (activeExpandedDetail === null || activeExpandedDetail === void 0 ? void 0 : (_activeExpandedDetail = activeExpandedDetail.params) === null || _activeExpandedDetail === void 0 ? void 0 : _activeExpandedDetail.eventId) === event._id || (activeExpandedDetail === null || activeExpandedDetail === void 0 ? void 0 : activeExpandedDetail.panelView) === 'hostDetail' && (activeExpandedDetail === null || activeExpandedDetail === void 0 ? void 0 : (_activeExpandedDetail2 = activeExpandedDetail.params) === null || _activeExpandedDetail2 === void 0 ? void 0 : _activeExpandedDetail2.hostName) === hostName || (activeExpandedDetail === null || activeExpandedDetail === void 0 ? void 0 : activeExpandedDetail.panelView) === 'networkDetail' && (activeExpandedDetail === null || activeExpandedDetail === void 0 ? void 0 : (_activeExpandedDetail3 = activeExpandedDetail.params) === null || _activeExpandedDetail3 === void 0 ? void 0 : _activeExpandedDetail3.ip) && (hostIPAddresses === null || hostIPAddresses === void 0 ? void 0 : hostIPAddresses.has(activeExpandedDetail === null || activeExpandedDetail === void 0 ? void 0 : (_activeExpandedDetail4 = activeExpandedDetail.params) === null || _activeExpandedDetail4 === void 0 ? void 0 : _activeExpandedDetail4.ip)) || false;
  const getNotesByIds = (0, _react.useMemo)(() => _store.appSelectors.notesByIdsSelector(), []);
  const notesById = (0, _use_selector.useDeepEqualSelector)(getNotesByIds);
  const noteIds = eventIdToNoteIds[event._id] || emptyNotes;
  const notes = (0, _react.useMemo)(() => _store.appSelectors.getNotes(notesById, noteIds).map(note => {
    var _note$lastEdit;
    return {
      savedObjectId: note.saveObjectId,
      note: note.note,
      noteId: note.id,
      updated: ((_note$lastEdit = note.lastEdit) !== null && _note$lastEdit !== void 0 ? _note$lastEdit : note.created).getTime(),
      updatedBy: note.user
    };
  }), [notesById, noteIds]);
  const hasRowRenderers = (0, _react.useMemo)(() => (0, _get_row_renderer.getRowRenderer)({
    data: event.ecs,
    rowRenderers
  }) != null, [event.ecs, rowRenderers]);
  const onToggleShowNotes = (0, _react.useCallback)(() => {
    const eventId = event._id;
    setShowNotes(prevShowNotes => {
      if (prevShowNotes[eventId]) {
        // notes are closing, so focus the notes button on the next tick, after escaping the EuiFocusTrap
        setTimeout(() => {
          var _trGroupRef$current;
          const notesButtonElement = (_trGroupRef$current = trGroupRef.current) === null || _trGroupRef$current === void 0 ? void 0 : _trGroupRef$current.querySelector(`.${_helpers3.NOTES_BUTTON_CLASS_NAME}`);
          notesButtonElement === null || notesButtonElement === void 0 ? void 0 : notesButtonElement.focus();
        }, 0);
      }
      return {
        ...prevShowNotes,
        [eventId]: !prevShowNotes[eventId]
      };
    });
  }, [event]);
  const handleOnEventDetailPanelOpened = (0, _react.useCallback)(() => {
    const eventId = event._id;
    // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
    const indexName = event._index;
    const updatedExpandedDetail = {
      panelView: 'eventDetail',
      params: {
        eventId,
        indexName,
        refetch
      }
    };
    dispatch(_timeline2.timelineActions.toggleDetailPanel({
      ...updatedExpandedDetail,
      tabType,
      id: timelineId
    }));
    if (timelineId === _timeline.TimelineId.active && tabType === _timeline.TimelineTabs.query) {
      _active_timeline_context.activeTimeline.toggleExpandedDetail({
        ...updatedExpandedDetail
      });
    }
  }, [dispatch, event._id, event._index, refetch, tabType, timelineId]);
  const associateNote = (0, _react.useCallback)(noteId => {
    dispatch(_timeline2.timelineActions.addNoteToEvent({
      eventId: event._id,
      id: timelineId,
      noteId
    }));
    if (!isEventPinned) {
      dispatch(_timeline2.timelineActions.pinEvent({
        id: timelineId,
        eventId: event._id
      }));
    }
  }, [dispatch, event, isEventPinned, timelineId]);
  const setEventsLoading = (0, _react.useCallback)(({
    eventIds,
    isLoading
  }) => {
    dispatch(_timeline2.timelineActions.setEventsLoading({
      id: timelineId,
      eventIds,
      isLoading
    }));
  }, [dispatch, timelineId]);
  const setEventsDeleted = (0, _react.useCallback)(({
    eventIds,
    isDeleted
  }) => {
    dispatch(_timeline2.timelineActions.setEventsDeleted({
      id: timelineId,
      eventIds,
      isDeleted
    }));
  }, [dispatch, timelineId]);
  return /*#__PURE__*/_react.default.createElement(_stateful_event_context.StatefulEventContext.Provider, {
    value: activeStatefulEventContext
  }, /*#__PURE__*/_react.default.createElement(_styles.EventsTrGroup, {
    $ariaRowindex: ariaRowindex,
    className: _helpers.STATEFUL_EVENT_CSS_CLASS_NAME,
    "data-test-subj": "event",
    eventType: (0, _helpers2.getEventType)(event.ecs),
    isBuildingBlockType: (0, _securitysolutionDataTable.isEventBuildingBlockType)(event.ecs),
    isEvenEqlSequence: (0, _helpers2.isEvenEqlSequence)(event.ecs),
    isExpanded: isDetailPanelExpanded,
    ref: trGroupRef,
    showLeftBorder: !isEventViewer
  }, /*#__PURE__*/_react.default.createElement(_event_column_view.EventColumnView, {
    id: event._id,
    actionsColumnWidth: actionsColumnWidth,
    ariaRowindex: ariaRowindex,
    columnHeaders: columnHeaders,
    data: event.data,
    ecsData: event.ecs,
    eventIdToNoteIds: eventIdToNoteIds,
    hasRowRenderers: hasRowRenderers,
    isEventPinned: isEventPinned,
    isEventViewer: isEventViewer,
    loadingEventIds: loadingEventIds,
    notesCount: notes.length,
    onEventDetailsPanelOpened: handleOnEventDetailPanelOpened,
    onRowSelected: onRowSelected,
    refetch: refetch,
    renderCellValue: renderCellValue,
    onRuleChange: onRuleChange,
    selectedEventIds: selectedEventIds,
    showCheckboxes: showCheckboxes,
    showNotes: !!showNotes[event._id],
    tabType: tabType,
    timelineId: timelineId,
    toggleShowNotes: onToggleShowNotes,
    leadingControlColumns: leadingControlColumns,
    trailingControlColumns: trailingControlColumns,
    setEventsLoading: setEventsLoading,
    setEventsDeleted: setEventsDeleted
  }), /*#__PURE__*/_react.default.createElement(EventsTrSupplementContainerWrapper, null, /*#__PURE__*/_react.default.createElement(_styles.EventsTrSupplement, {
    className: "siemEventsTable__trSupplement--notes",
    "data-test-subj": "event-notes-flex-item",
    $display: "block"
  }, /*#__PURE__*/_react.default.createElement(_note_cards.NoteCards, {
    ariaRowindex: ariaRowindex,
    associateNote: associateNote,
    "data-test-subj": "note-cards",
    notes: notes,
    showAddNote: !!showNotes[event._id],
    toggleShowAddNote: onToggleShowNotes
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_styles.EventsTrSupplement, null, /*#__PURE__*/_react.default.createElement(_stateful_row_renderer.StatefulRowRenderer, {
    ariaRowindex: ariaRowindex,
    containerRef: containerRef,
    event: event,
    lastFocusedAriaColindex: lastFocusedAriaColindex,
    rowRenderers: rowRenderers,
    timelineId: timelineId
  })))))));
};
const StatefulEvent = /*#__PURE__*/_react.default.memo(StatefulEventComponent);
exports.StatefulEvent = StatefulEvent;