"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloseButton = exports.Actions = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styles = require("../../../styles");
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** Given a `header`, returns the `SortDirection` applicable to it */

const CloseButton = /*#__PURE__*/_react.default.memo(({
  columnId,
  onColumnRemoved
}) => {
  const handleClick = (0, _react.useCallback)(event => {
    // To avoid a re-sorting when you delete a column
    event.preventDefault();
    event.stopPropagation();
    onColumnRemoved(columnId);
  }, [columnId, onColumnRemoved]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": i18n.REMOVE_COLUMN,
    color: "text",
    "data-test-subj": "remove-column",
    iconType: "cross",
    onClick: handleClick
  });
});
exports.CloseButton = CloseButton;
CloseButton.displayName = 'CloseButton';
const Actions = /*#__PURE__*/_react.default.memo(({
  header,
  onColumnRemoved,
  sort,
  isLoading
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, sort.some(i => i.columnId === header.id) && isLoading ? /*#__PURE__*/_react.default.createElement(_styles.EventsHeadingExtra, {
    className: "siemEventsHeading__extra--loading"
  }, /*#__PURE__*/_react.default.createElement(_styles.EventsLoading, {
    "data-test-subj": "timeline-loading-spinner"
  })) : /*#__PURE__*/_react.default.createElement(_styles.EventsHeadingExtra, {
    className: "siemEventsHeading__extra--close"
  }, /*#__PURE__*/_react.default.createElement(CloseButton, {
    columnId: header.id,
    onColumnRemoved: onColumnRemoved
  })));
});
exports.Actions = Actions;
Actions.displayName = 'Actions';