"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHostIsolationTools = void 0;
var _react = require("react");
var _endpoint_host_isolation_cases_context = require("../../../../common/components/endpoint/host_isolation/endpoint_host_isolation_cases_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialHostIsolationState = {
  isolateAction: 'isolateHost',
  isHostIsolationPanelOpen: false,
  isIsolateActionSuccessBannerVisible: false
};
function hostIsolationReducer(state, action) {
  switch (action.type) {
    case 'setIsolateAction':
      return {
        ...state,
        isolateAction: action.isolateAction
      };
    case 'setIsHostIsolationPanel':
      return {
        ...state,
        isHostIsolationPanelOpen: action.isHostIsolationPanelOpen
      };
    case 'setIsIsolateActionSuccessBannerVisible':
      return {
        ...state,
        isIsolateActionSuccessBannerVisible: action.isIsolateActionSuccessBannerVisible
      };
    default:
      throw new Error();
  }
}
const useHostIsolationTools = () => {
  const [{
    isolateAction,
    isHostIsolationPanelOpen,
    isIsolateActionSuccessBannerVisible
  }, dispatch] = (0, _react.useReducer)(hostIsolationReducer, initialHostIsolationState);
  const showAlertDetails = (0, _react.useCallback)(() => {
    dispatch({
      type: 'setIsHostIsolationPanel',
      isHostIsolationPanelOpen: false
    });
    dispatch({
      type: 'setIsIsolateActionSuccessBannerVisible',
      isIsolateActionSuccessBannerVisible: false
    });
  }, []);
  const showHostIsolationPanel = (0, _react.useCallback)(action => {
    if (action === 'isolateHost' || action === 'unisolateHost') {
      dispatch({
        type: 'setIsHostIsolationPanel',
        isHostIsolationPanelOpen: true
      });
      dispatch({
        type: 'setIsolateAction',
        isolateAction: action
      });
    }
  }, []);
  const caseDetailsRefresh = (0, _endpoint_host_isolation_cases_context.useWithCaseDetailsRefresh)();
  const handleIsolationActionSuccess = (0, _react.useCallback)(() => {
    dispatch({
      type: 'setIsIsolateActionSuccessBannerVisible',
      isIsolateActionSuccessBannerVisible: true
    });
    // If a case details refresh ref is defined, then refresh actions and comments
    if (caseDetailsRefresh) {
      caseDetailsRefresh.refreshCase();
    }
  }, [caseDetailsRefresh]);
  return (0, _react.useMemo)(() => ({
    isolateAction,
    isHostIsolationPanelOpen,
    isIsolateActionSuccessBannerVisible,
    handleIsolationActionSuccess,
    showAlertDetails,
    showHostIsolationPanel
  }), [isHostIsolationPanelOpen, isIsolateActionSuccessBannerVisible, isolateAction, handleIsolationActionSuccess, showAlertDetails, showHostIsolationPanel]);
};
exports.useHostIsolationTools = useHostIsolationTools;