"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventDetailsPanel = void 0;
var _elasticAssistant = require("@kbn/elastic-assistant");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _use_get_fields_data = require("../../../../common/hooks/use_get_fields_data");
var _use_assistant_availability = require("../../../../assistant/use_assistant_availability");
var _helpers = require("../../../../assistant/helpers");
var _expandable_event = require("./expandable_event");
var _details = require("../../../containers/details");
var _use_host_isolation_tools = require("./use_host_isolation_tools");
var _flyout = require("./flyout");
var _helpers2 = require("./helpers");
var _use_space_id = require("../../../../common/hooks/use_space_id");
var _host_isolation = require("../../../../common/components/endpoint/host_isolation");
var _host_isolation2 = require("../../../../detections/components/host_isolation");
var _translations = require("../../../../common/components/event_details/translations");
var _prompt_contexts = require("../../../../assistant/content/prompt_contexts");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FlyoutFooterContainerPanel = (0, _styledComponents.default)(_eui.EuiPanel)`
  .side-panel-flyout-footer {
    background-color: transparent;
  }
`;
const useAssistantNoop = () => ({
  promptContextId: undefined
});
const EventDetailsPanelComponent = ({
  browserFields,
  entityType = 'events',
  // Default to events so only alerts have to pass entityType in
  expandedEvent,
  handleOnEventClosed,
  isDraggable,
  isFlyoutView,
  runtimeMappings,
  tabType,
  scopeId,
  isReadOnly
}) => {
  var _getAlertIndexAlias, _expandedEvent$eventI;
  const {
    hasAssistantPrivilege
  } = (0, _use_assistant_availability.useAssistantAvailability)();
  // TODO: changing feature flags requires a hard refresh to take effect, but this temporary workaround technically violates the rules of hooks:
  const useAssistant = hasAssistantPrivilege ? _elasticAssistant.useAssistantOverlay : useAssistantNoop;
  const currentSpaceId = (0, _use_space_id.useSpaceId)();
  const {
    indexName
  } = expandedEvent;
  const eventIndex = (_getAlertIndexAlias = (0, _helpers2.getAlertIndexAlias)(indexName, currentSpaceId)) !== null && _getAlertIndexAlias !== void 0 ? _getAlertIndexAlias : indexName;
  const [loading, detailsData, rawEventData, ecsData, refetchFlyoutData] = (0, _details.useTimelineEventsDetails)({
    entityType,
    indexName: eventIndex !== null && eventIndex !== void 0 ? eventIndex : '',
    eventId: (_expandedEvent$eventI = expandedEvent.eventId) !== null && _expandedEvent$eventI !== void 0 ? _expandedEvent$eventI : '',
    runtimeMappings,
    skip: !expandedEvent.eventId
  });
  const getFieldsData = (0, _use_get_fields_data.useGetFieldsData)(rawEventData === null || rawEventData === void 0 ? void 0 : rawEventData.fields);
  const {
    isolateAction,
    isHostIsolationPanelOpen,
    isIsolateActionSuccessBannerVisible,
    handleIsolationActionSuccess,
    showAlertDetails,
    showHostIsolationPanel
  } = (0, _use_host_isolation_tools.useHostIsolationTools)();
  const {
    alertId,
    isAlert,
    hostName,
    ruleName,
    timestamp
  } = (0, _helpers2.useBasicDataFromDetailsData)(detailsData);
  const view = (0, _react.useMemo)(() => isFlyoutView ? _translations.SUMMARY_VIEW : _translations.TIMELINE_VIEW, [isFlyoutView]);
  const getPromptContext = (0, _react.useCallback)(async () => (0, _helpers.getRawData)(detailsData !== null && detailsData !== void 0 ? detailsData : []), [detailsData]);
  const {
    promptContextId
  } = useAssistant(isAlert ? 'alert' : 'event', isAlert ? _translations.ALERT_SUMMARY_CONVERSATION_ID : _translations.EVENT_SUMMARY_CONVERSATION_ID, isAlert ? (0, _translations.ALERT_SUMMARY_CONTEXT_DESCRIPTION)(view) : (0, _translations.EVENT_SUMMARY_CONTEXT_DESCRIPTION)(view), getPromptContext, null, isAlert ? _prompt_contexts.PROMPT_CONTEXTS[_prompt_contexts.PROMPT_CONTEXT_ALERT_CATEGORY].suggestedUserPrompt : _prompt_contexts.PROMPT_CONTEXTS[_prompt_contexts.PROMPT_CONTEXT_EVENT_CATEGORY].suggestedUserPrompt, isAlert ? _translations.ALERT_SUMMARY_VIEW_CONTEXT_TOOLTIP : _translations.EVENT_SUMMARY_VIEW_CONTEXT_TOOLTIP);
  const header = (0, _react.useMemo)(() => isFlyoutView || isHostIsolationPanelOpen ? /*#__PURE__*/_react.default.createElement(_flyout.FlyoutHeader, {
    eventId: expandedEvent.eventId,
    eventIndex: eventIndex,
    isHostIsolationPanelOpen: isHostIsolationPanelOpen,
    isAlert: isAlert,
    isolateAction: isolateAction,
    loading: loading,
    ruleName: ruleName,
    showAlertDetails: showAlertDetails,
    timestamp: timestamp,
    promptContextId: promptContextId,
    scopeId: scopeId,
    refetchFlyoutData: refetchFlyoutData,
    getFieldsData: getFieldsData
  }) : /*#__PURE__*/_react.default.createElement(_expandable_event.ExpandableEventTitle, {
    eventId: expandedEvent.eventId,
    eventIndex: eventIndex,
    isAlert: isAlert,
    loading: loading,
    ruleName: ruleName,
    timestamp: timestamp,
    handleOnEventClosed: handleOnEventClosed,
    promptContextId: promptContextId,
    scopeId: scopeId,
    refetchFlyoutData: refetchFlyoutData,
    getFieldsData: getFieldsData
  }), [isFlyoutView, isHostIsolationPanelOpen, expandedEvent.eventId, eventIndex, isAlert, isolateAction, loading, ruleName, showAlertDetails, timestamp, promptContextId, handleOnEventClosed, scopeId, refetchFlyoutData, getFieldsData]);
  const body = (0, _react.useMemo)(() => {
    if (isFlyoutView) {
      return /*#__PURE__*/_react.default.createElement(_flyout.FlyoutBody, {
        alertId: alertId,
        browserFields: browserFields,
        detailsData: detailsData,
        detailsEcsData: ecsData,
        event: expandedEvent,
        hostName: hostName,
        handleIsolationActionSuccess: handleIsolationActionSuccess,
        handleOnEventClosed: handleOnEventClosed,
        isAlert: isAlert,
        isDraggable: isDraggable,
        isolateAction: isolateAction,
        isIsolateActionSuccessBannerVisible: isIsolateActionSuccessBannerVisible,
        isHostIsolationPanelOpen: isHostIsolationPanelOpen,
        loading: loading,
        rawEventData: rawEventData,
        showAlertDetails: showAlertDetails,
        scopeId: scopeId,
        isReadOnly: isReadOnly
      });
    } else if (isHostIsolationPanelOpen) {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isIsolateActionSuccessBannerVisible && /*#__PURE__*/_react.default.createElement(_host_isolation.EndpointIsolateSuccess, {
        hostName: hostName,
        alertId: alertId,
        isolateAction: isolateAction
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_host_isolation2.HostIsolationPanel, {
        details: detailsData,
        cancelCallback: showAlertDetails,
        successCallback: handleIsolationActionSuccess,
        isolateAction: isolateAction
      })));
    } else {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m"
      }), /*#__PURE__*/_react.default.createElement(_expandable_event.ExpandableEvent, {
        browserFields: browserFields,
        detailsData: detailsData,
        detailsEcsData: ecsData,
        event: expandedEvent,
        isAlert: isAlert,
        isDraggable: isDraggable,
        loading: loading,
        rawEventData: rawEventData,
        scopeId: scopeId,
        timelineTabType: tabType,
        handleOnEventClosed: handleOnEventClosed
      }));
    }
  }, [alertId, browserFields, detailsData, ecsData, expandedEvent, handleIsolationActionSuccess, handleOnEventClosed, hostName, isAlert, isDraggable, isFlyoutView, isHostIsolationPanelOpen, isIsolateActionSuccessBannerVisible, isReadOnly, isolateAction, loading, rawEventData, showAlertDetails, tabType, scopeId]);
  if (!(expandedEvent !== null && expandedEvent !== void 0 && expandedEvent.eventId)) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, header, body, /*#__PURE__*/_react.default.createElement(FlyoutFooterContainerPanel, {
    hasShadow: false,
    borderRadius: "none"
  }, /*#__PURE__*/_react.default.createElement(_flyout.FlyoutFooter, {
    detailsData: detailsData,
    detailsEcsData: ecsData,
    refetchFlyoutData: refetchFlyoutData,
    handleOnEventClosed: handleOnEventClosed,
    isHostIsolationPanelOpen: isHostIsolationPanelOpen,
    isReadOnly: isReadOnly,
    loadingEventDetails: loading,
    onAddIsolationStatusClick: showHostIsolationPanel,
    scopeId: scopeId
  })));
};
const EventDetailsPanel = /*#__PURE__*/_react.default.memo(EventDetailsPanelComponent, (prevProps, nextProps) => (0, _fastDeepEqual.default)(prevProps.browserFields, nextProps.browserFields) && (0, _fastDeepEqual.default)(prevProps.expandedEvent, nextProps.expandedEvent) && prevProps.scopeId === nextProps.scopeId && prevProps.isDraggable === nextProps.isDraggable);
exports.EventDetailsPanel = EventDetailsPanel;