"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LibraryExample = void 0;
var _react = _interopRequireDefault(require("react"));
var _library_load_event = require("../../../../common/demo_data/endpoint/library_load_event");
var _generic_row_renderer = require("../../timeline/body/renderers/system/generic_row_renderer");
var _translations = require("../../timeline/body/renderers/system/translations");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LibraryExampleComponent = () => {
  const libraryRowRenderer = (0, _generic_row_renderer.createEndpointLibraryRowRenderer)({
    actionName: 'load',
    text: _translations.LOADED_LIBRARY
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, libraryRowRenderer.renderRow({
    data: _library_load_event.demoEndpointLibraryLoadEvent,
    isDraggable: false,
    scopeId: _constants.ROW_RENDERER_BROWSER_EXAMPLE_TIMELINE_ID
  }));
};
const LibraryExample = /*#__PURE__*/_react.default.memo(LibraryExampleComponent);
exports.LibraryExample = LibraryExample;