"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderers = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _timeline = require("../../../../../common/api/timeline");
var _examples = require("../examples");
var _constants = require("./constants");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Link = ({
  children,
  url
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
  href: url,
  target: "_blank",
  rel: "noopener nofollow noreferrer",
  "data-test-subj": "externalLink"
}, children);
const renderers = [{
  id: _timeline.RowRendererId.alerts,
  name: _constants.eventRendererNames[_timeline.RowRendererId.alerts],
  description: i18n.ALERTS_DESCRIPTION,
  example: _examples.AlertsExample,
  searchableDescription: i18n.ALERTS_DESCRIPTION
}, {
  id: _timeline.RowRendererId.auditd,
  name: _constants.eventRendererNames[_timeline.RowRendererId.auditd],
  description: /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(Link, {
    url: "https://www.elastic.co/guide/en/beats/auditbeat/current/auditbeat-module-auditd.html"
  }, i18n.AUDITD_NAME), ' ', i18n.AUDITD_DESCRIPTION_PART1),
  example: _examples.AuditdExample,
  searchableDescription: `${i18n.AUDITD_NAME} ${i18n.AUDITD_DESCRIPTION_PART1}`
}, {
  id: _timeline.RowRendererId.auditd_file,
  name: _constants.eventRendererNames[_timeline.RowRendererId.auditd_file],
  description: /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(Link, {
    url: "https://www.elastic.co/guide/en/beats/auditbeat/current/auditbeat-module-auditd.html"
  }, i18n.AUDITD_NAME), ' ', i18n.AUDITD_FILE_DESCRIPTION_PART1),
  example: _examples.AuditdFileExample,
  searchableDescription: `${i18n.AUDITD_FILE_NAME} ${i18n.AUDITD_FILE_DESCRIPTION_PART1}`
}, {
  id: _timeline.RowRendererId.library,
  name: _constants.eventRendererNames[_timeline.RowRendererId.library],
  description: i18n.LIBRARY_DESCRIPTION,
  example: _examples.LibraryExample,
  searchableDescription: i18n.LIBRARY_DESCRIPTION
}, {
  id: _timeline.RowRendererId.system_security_event,
  name: _constants.eventRendererNames[_timeline.RowRendererId.system_security_event],
  description: /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("p", null, i18n.AUTHENTICATION_DESCRIPTION_PART1), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement("p", null, i18n.AUTHENTICATION_DESCRIPTION_PART2)),
  example: _examples.SystemSecurityEventExample,
  searchableDescription: `${i18n.AUTHENTICATION_DESCRIPTION_PART1} ${i18n.AUTHENTICATION_DESCRIPTION_PART2}`
}, {
  id: _timeline.RowRendererId.system_dns,
  name: _constants.eventRendererNames[_timeline.RowRendererId.system_dns],
  description: i18n.DNS_DESCRIPTION_PART1,
  example: _examples.SystemDnsExample,
  searchableDescription: i18n.DNS_DESCRIPTION_PART1
}, {
  id: _timeline.RowRendererId.netflow,
  name: _constants.eventRendererNames[_timeline.RowRendererId.netflow],
  description: /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("p", null, i18n.FLOW_DESCRIPTION_PART1), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement("p", null, i18n.FLOW_DESCRIPTION_PART2)),
  example: _examples.NetflowExample,
  searchableDescription: `${i18n.FLOW_DESCRIPTION_PART1} ${i18n.FLOW_DESCRIPTION_PART2}`
}, {
  id: _timeline.RowRendererId.system,
  name: _constants.eventRendererNames[_timeline.RowRendererId.system],
  description: /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("p", null, i18n.SYSTEM_DESCRIPTION_PART1, ' ', /*#__PURE__*/_react.default.createElement(Link, {
    url: "https://www.elastic.co/guide/en/beats/auditbeat/current/auditbeat-module-system.html"
  }, i18n.SYSTEM_NAME), ' ', i18n.SYSTEM_DESCRIPTION_PART2), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement("p", null, i18n.SYSTEM_DESCRIPTION_PART3)),
  example: _examples.SystemExample,
  searchableDescription: `${i18n.SYSTEM_DESCRIPTION_PART1} ${i18n.SYSTEM_NAME} ${i18n.SYSTEM_DESCRIPTION_PART2} ${i18n.SYSTEM_DESCRIPTION_PART3}`
}, {
  id: _timeline.RowRendererId.system_endgame_process,
  name: _constants.eventRendererNames[_timeline.RowRendererId.system_endgame_process],
  description: /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("p", null, i18n.PROCESS_DESCRIPTION_PART1), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement("p", null, i18n.PROCESS_DESCRIPTION_PART2)),
  example: _examples.SystemEndgameProcessExample,
  searchableDescription: `${i18n.PROCESS_DESCRIPTION_PART1} ${i18n.PROCESS_DESCRIPTION_PART2}`
}, {
  id: _timeline.RowRendererId.registry,
  name: _constants.eventRendererNames[_timeline.RowRendererId.registry],
  description: i18n.REGISTRY_DESCRIPTION,
  example: _examples.RegistryExample,
  searchableDescription: i18n.REGISTRY_DESCRIPTION
}, {
  id: _timeline.RowRendererId.system_fim,
  name: _constants.eventRendererNames[_timeline.RowRendererId.system_fim],
  description: i18n.FIM_DESCRIPTION_PART1,
  example: _examples.SystemFimExample,
  searchableDescription: i18n.FIM_DESCRIPTION_PART1
}, {
  id: _timeline.RowRendererId.system_file,
  name: _constants.eventRendererNames[_timeline.RowRendererId.system_file],
  description: i18n.FILE_DESCRIPTION_PART1,
  example: _examples.SystemFileExample,
  searchableDescription: i18n.FILE_DESCRIPTION_PART1
}, {
  id: _timeline.RowRendererId.system_socket,
  name: _constants.eventRendererNames[_timeline.RowRendererId.system_socket],
  description: /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("p", null, i18n.SOCKET_DESCRIPTION_PART1), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement("p", null, i18n.SOCKET_DESCRIPTION_PART2)),
  example: _examples.SystemSocketExample,
  searchableDescription: `${i18n.SOCKET_DESCRIPTION_PART1} ${i18n.SOCKET_DESCRIPTION_PART2}`
}, {
  id: _timeline.RowRendererId.suricata,
  name: _constants.eventRendererNames[_timeline.RowRendererId.suricata],
  description: /*#__PURE__*/_react.default.createElement("p", null, i18n.SURICATA_DESCRIPTION_PART1, ' ', /*#__PURE__*/_react.default.createElement(Link, {
    url: "https://www.elastic.co/guide/en/beats/filebeat/current/filebeat-module-suricata.html"
  }, i18n.SURICATA_NAME), ' ', i18n.SURICATA_DESCRIPTION_PART2),
  example: _examples.SuricataExample,
  searchableDescription: `${i18n.SURICATA_DESCRIPTION_PART1} ${i18n.SURICATA_NAME} ${i18n.SURICATA_DESCRIPTION_PART2}`
}, {
  id: _timeline.RowRendererId.threat_match,
  name: _constants.eventRendererNames[_timeline.RowRendererId.threat_match],
  description: i18n.THREAT_MATCH_DESCRIPTION,
  example: _examples.ThreatMatchExample,
  searchableDescription: `${i18n.THREAT_MATCH_NAME} ${i18n.THREAT_MATCH_DESCRIPTION}`
}, {
  id: _timeline.RowRendererId.zeek,
  name: _constants.eventRendererNames[_timeline.RowRendererId.zeek],
  description: /*#__PURE__*/_react.default.createElement("p", null, i18n.ZEEK_DESCRIPTION_PART1, ' ', /*#__PURE__*/_react.default.createElement(Link, {
    url: "https://www.elastic.co/guide/en/beats/filebeat/current/filebeat-module-zeek.html"
  }, i18n.ZEEK_NAME), ' ', i18n.ZEEK_DESCRIPTION_PART2),
  example: _examples.ZeekExample,
  searchableDescription: `${i18n.ZEEK_DESCRIPTION_PART1} ${i18n.ZEEK_NAME} ${i18n.ZEEK_DESCRIPTION_PART2}`
}];
exports.renderers = renderers;