"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.YOU_ARE_VIEWING_NOTES = exports.YOU_ARE_EDITING_A_NOTE = exports.SEARCH_PLACEHOLDER = exports.NOTES = exports.NOTE = exports.CREATED_BY = exports.CANCEL = exports.ADD_NOTE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ADD_NOTE = _i18n.i18n.translate('xpack.securitySolution.notes.addNoteButtonLabel', {
  defaultMessage: 'Add Note'
});
exports.ADD_NOTE = ADD_NOTE;
const NOTE = _i18n.i18n.translate('xpack.securitySolution.notes.noteLabel', {
  defaultMessage: 'Note'
});
exports.NOTE = NOTE;
const NOTES = _i18n.i18n.translate('xpack.securitySolution.notes.notesTitle', {
  defaultMessage: 'Notes'
});
exports.NOTES = NOTES;
const SEARCH_PLACEHOLDER = _i18n.i18n.translate('xpack.securitySolution.notes.search.FilterByUserOrNotePlaceholder', {
  defaultMessage: 'Filter by User or Note'
});
exports.SEARCH_PLACEHOLDER = SEARCH_PLACEHOLDER;
const CANCEL = _i18n.i18n.translate('xpack.securitySolution.notes.cancelButtonLabel', {
  defaultMessage: 'Cancel'
});
exports.CANCEL = CANCEL;
const YOU_ARE_EDITING_A_NOTE = _i18n.i18n.translate('xpack.securitySolution.notes.youAreEditingANoteScreenReaderOnly', {
  defaultMessage: 'You are editing a note. Click Add Note when finished, or press escape to cancel.'
});
exports.YOU_ARE_EDITING_A_NOTE = YOU_ARE_EDITING_A_NOTE;
const YOU_ARE_VIEWING_NOTES = row => _i18n.i18n.translate('xpack.securitySolution.notes.youAreViewingNotesScreenReaderOnly', {
  values: {
    row
  },
  defaultMessage: 'You are viewing notes for the event in row {row}. Press the up arrow key when finished to return to the event.'
});
exports.YOU_ARE_VIEWING_NOTES = YOU_ARE_VIEWING_NOTES;
const CREATED_BY = _i18n.i18n.translate('xpack.securitySolution.notes.createdByLabel', {
  defaultMessage: 'Created by'
});
exports.CREATED_BY = CREATED_BY;