"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EVENT_START_FIELD_NAME = exports.EVENT_END_FIELD_NAME = exports.DurationEventStartEnd = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _draggables = require("../../../../common/components/draggables");
var _duration = require("../../duration");
var _formatted_date = require("../../../../common/components/formatted_date");
var _formatted_duration = require("../../formatted_duration");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EVENT_START_FIELD_NAME = 'event.start';
exports.EVENT_START_FIELD_NAME = EVENT_START_FIELD_NAME;
const EVENT_END_FIELD_NAME = 'event.end';
exports.EVENT_END_FIELD_NAME = EVENT_END_FIELD_NAME;
const TimeIcon = (0, _styledComponents.default)(_eui.EuiIcon)`
  margin-right: 3px;
  position: relative;
  top: -1px;
`;
TimeIcon.displayName = 'TimeIcon';

/**
 * Renders a column of draggable badges containing:
 * - `event.duration`
 * - `event.start`
 * - `event.end`
 */
const DurationEventStartEnd = /*#__PURE__*/_react.default.memo(({
  contextId,
  eventDuration,
  eventId,
  eventEnd,
  eventStart,
  isDraggable
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "flexStart",
  "data-test-subj": "duration-and-start-group",
  direction: "column",
  justifyContent: "center",
  gutterSize: "none"
}, eventDuration != null ? (0, _fp.uniq)(eventDuration).map(duration => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  key: duration
}, /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
  field: _duration.EVENT_DURATION_FIELD_NAME,
  id: `duration-event-start-end-default-draggable-${contextId}-${eventId}-${_duration.EVENT_DURATION_FIELD_NAME}-${duration}`,
  isDraggable: isDraggable
  // @ts-expect-error
  ,
  name: name,
  tooltipContent: null,
  value: duration
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "xs"
}, /*#__PURE__*/_react.default.createElement(TimeIcon, {
  size: "m",
  type: "clock"
}), /*#__PURE__*/_react.default.createElement(_formatted_duration.FormattedDuration, {
  maybeDurationNanoseconds: duration,
  tooltipTitle: _duration.EVENT_DURATION_FIELD_NAME
}))))) : null, eventStart != null ? (0, _fp.uniq)(eventStart).map(start => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  key: start
}, /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
  field: EVENT_START_FIELD_NAME,
  id: `duration-event-start-end-default-draggable-${contextId}-${eventId}-${EVENT_START_FIELD_NAME}-${start}`,
  isDraggable: isDraggable,
  tooltipContent: null,
  value: start
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "xs"
}, /*#__PURE__*/_react.default.createElement(TimeIcon, {
  size: "m",
  type: "clock"
}), /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
  fieldName: EVENT_START_FIELD_NAME,
  value: start
}))))) : null, eventEnd != null ? (0, _fp.uniq)(eventEnd).map(end => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  key: end
}, /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
  field: EVENT_END_FIELD_NAME,
  id: `duration-event-start-end-default-draggable-${contextId}-${eventId}-${EVENT_END_FIELD_NAME}-${end}`,
  isDraggable: isDraggable,
  tooltipContent: null,
  value: end
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "xs"
}, /*#__PURE__*/_react.default.createElement(TimeIcon, {
  size: "m",
  type: "clock"
}), /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
  fieldName: EVENT_END_FIELD_NAME,
  value: end
}))))) : null));
exports.DurationEventStartEnd = DurationEventStartEnd;
DurationEventStartEnd.displayName = 'DurationEventStartEnd';