"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.insertPositions = exports.EuiPortal = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _react = require("react");
var _reactDom = require("react-dom");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * NOTE: We can't test this component because Enzyme doesn't support rendering
 * into portals.
 */

const insertPositions = {
  after: 'afterend',
  before: 'beforebegin'
};
exports.insertPositions = insertPositions;
class EuiPortal extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "portalNode", null);
    if (typeof window === 'undefined') return; // Prevent SSR errors

    const {
      insert
    } = this.props;
    this.portalNode = document.createElement('div');
    this.portalNode.dataset.euiportal = 'true';
    if (insert == null || insert.sibling == null) {
      // no insertion defined, append to body
      document.body.appendChild(this.portalNode);
    } else {
      // inserting before or after an element
      const {
        sibling,
        position
      } = insert;
      sibling.insertAdjacentElement(insertPositions[position], this.portalNode);
    }
  }
  componentDidMount() {
    this.updatePortalRef(this.portalNode);
  }
  componentWillUnmount() {
    var _this$portalNode;
    if ((_this$portalNode = this.portalNode) !== null && _this$portalNode !== void 0 && _this$portalNode.parentNode) {
      this.portalNode.parentNode.removeChild(this.portalNode);
    }
    this.updatePortalRef(null);
  }
  componentDidUpdate(prevProps) {
    var _this$portalNode2;
    if (!(0, _fastDeepEqual.default)(prevProps.insert, this.props.insert) && (_this$portalNode2 = this.portalNode) !== null && _this$portalNode2 !== void 0 && _this$portalNode2.parentNode) {
      this.portalNode.parentNode.removeChild(this.portalNode);
    }
    if (this.portalNode) {
      if (this.props.insert == null || this.props.insert.sibling == null) {
        // no insertion defined, append to body
        document.body.appendChild(this.portalNode);
      } else {
        // inserting before or after an element
        const {
          sibling,
          position
        } = this.props.insert;
        sibling.insertAdjacentElement(insertPositions[position], this.portalNode);
      }
    }
  }
  updatePortalRef(ref) {
    if (this.props.portalRef) {
      this.props.portalRef(ref);
    }
  }
  render() {
    return this.portalNode ? /*#__PURE__*/(0, _reactDom.createPortal)(this.props.children, this.portalNode) : null;
  }
}
exports.EuiPortal = EuiPortal;