"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelineStatusInfo = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _timeline = require("../../../../../common/api/timeline");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NoWrapText = (0, _styledComponents.default)(_eui.EuiText)`
  white-space: nowrap;
`;
const TimelineStatusInfo = /*#__PURE__*/_react.default.memo(({
  status,
  updated,
  changed
}) => {
  const isUnsaved = status === _timeline.TimelineStatus.draft;
  let statusContent = null;
  if (isUnsaved || !updated) {
    statusContent = /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "warning"
    }, i18n.UNSAVED);
  } else if (changed) {
    statusContent = /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "warning"
    }, i18n.UNSAVED_CHANGES);
  }
  if (!statusContent) return null;
  return /*#__PURE__*/_react.default.createElement(NoWrapText, {
    size: "xs",
    "data-test-subj": "timeline-status"
  }, statusContent);
});
exports.TimelineStatusInfo = TimelineStatusInfo;
TimelineStatusInfo.displayName = 'TimelineStatusInfo';