"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActiveTimelines = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _fp = require("lodash/fp");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _timeline = require("../../../../../common/api/timeline");
var _use_timeline_events_count = require("../../../../common/hooks/use_timeline_events_count");
var _helpers = require("../../timeline/helpers");
var _translations = require("../../timeline/properties/translations");
var _timeline2 = require("../../../store/timeline");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledEuiButtonEmpty = (0, _styledComponents.default)(_eui.EuiButtonEmpty)`
  &:active,
  &:focus {
    background: transparent;
  }
  > span {
    padding: 0;
  }
`;
const TitleConatiner = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  overflow: hidden;
  display: inline-block;
  text-overflow: ellipsis;
  white-space: nowrap;
`;
const ActiveTimelinesComponent = ({
  timelineId,
  timelineType,
  timelineTitle,
  isOpen
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const handleToggleOpen = (0, _react.useCallback)(() => {
    dispatch(_timeline2.timelineActions.showTimeline({
      id: timelineId,
      show: !isOpen
    }));
    (0, _helpers.focusActiveTimelineButton)();
  }, [dispatch, isOpen, timelineId]);
  const title = !(0, _fp.isEmpty)(timelineTitle) ? timelineTitle : timelineType === _timeline.TimelineType.template ? _translations.UNTITLED_TEMPLATE : _translations.UNTITLED_TIMELINE;
  const titleContent = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "none",
      alignItems: "center",
      justifyContent: "flexStart",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(TitleConatiner, {
      "data-test-subj": "timeline-title",
      grow: false
    }, isOpen ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement("h3", null, title)) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, title)), !isOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_use_timeline_events_count.TimelineEventsCountBadge, null)));
  }, [isOpen, title]);
  if (isOpen) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, titleContent);
  }
  return /*#__PURE__*/_react.default.createElement(StyledEuiButtonEmpty, {
    "aria-label": i18n.TIMELINE_TOGGLE_BUTTON_ARIA_LABEL({
      isOpen,
      title
    }),
    className: _helpers.ACTIVE_TIMELINE_BUTTON_CLASS_NAME,
    flush: "both",
    "data-test-subj": "flyoutOverlay",
    size: "s",
    isSelected: isOpen,
    onClick: handleToggleOpen
  }, titleContent);
};
const ActiveTimelines = /*#__PURE__*/_react.default.memo(ActiveTimelinesComponent);
exports.ActiveTimelines = ActiveTimelines;