"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutBottomBar = void 0;
var _react = _interopRequireDefault(require("react"));
var _helpers = require("../../timeline/helpers");
var _header = require("../header");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FlyoutBottomBar = /*#__PURE__*/_react.default.memo(({
  showTimelineHeaderPanel,
  timelineId
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    className: _helpers.FLYOUT_BUTTON_BAR_CLASS_NAME,
    "data-test-subj": "flyoutBottomBar"
  }, showTimelineHeaderPanel && /*#__PURE__*/_react.default.createElement(_header.FlyoutHeaderPanel, {
    timelineId: timelineId
  }));
});
exports.FlyoutBottomBar = FlyoutBottomBar;
FlyoutBottomBar.displayName = 'FlyoutBottomBar';