"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInvestigateInTimeline = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _defaults = require("../timelines/store/timeline/defaults");
var _constants = require("../../common/constants");
var _timeline = require("../../common/types/timeline");
var _timeline2 = require("../../common/api/timeline");
var _use_selector = require("../common/hooks/use_selector");
var _kibana = require("../common/lib/kibana");
var _use_start_transaction = require("../common/lib/apm/use_start_transaction");
var _timeline3 = require("../timelines/store/timeline");
var _use_create_timeline = require("../timelines/components/timeline/properties/use_create_timeline");
var _helpers = require("../timelines/components/open_timeline/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook passed down to the Threat Intelligence plugin, via context.
 * This code is closely duplicated from here: https://github.com/elastic/kibana/blob/main/x-pack/plugins/security_solution/public/detections/components/alerts_table/timeline_actions/use_investigate_in_timeline.tsx,
 * the main changes being:
 * - no exceptions are handled at the moment
 * - we use dataProviders, from and to directly instead of consuming ecsData
 */
const useInvestigateInTimeline = ({
  dataProviders,
  from,
  to
}) => {
  const {
    data: {
      query
    }
  } = (0, _kibana.useKibana)().services;
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    startTransaction
  } = (0, _use_start_transaction.useStartTransaction)();
  const filterManagerBackup = (0, _react.useMemo)(() => query.filterManager, [query.filterManager]);
  const getManageTimeline = (0, _react.useMemo)(() => _timeline3.timelineSelectors.getTimelineByIdSelector(), []);
  const {
    filterManager: activeFilterManager
  } = (0, _use_selector.useDeepEqualSelector)(state => {
    var _TimelineId$active;
    return getManageTimeline(state, (_TimelineId$active = _timeline.TimelineId.active) !== null && _TimelineId$active !== void 0 ? _TimelineId$active : '');
  });
  const filterManager = (0, _react.useMemo)(() => activeFilterManager !== null && activeFilterManager !== void 0 ? activeFilterManager : filterManagerBackup, [activeFilterManager, filterManagerBackup]);
  const updateTimelineIsLoading = (0, _react.useCallback)(payload => dispatch(_timeline3.timelineActions.updateIsLoading(payload)), [dispatch]);
  const clearActiveTimeline = (0, _use_create_timeline.useCreateTimeline)({
    timelineId: _timeline.TimelineId.active,
    timelineType: _timeline2.TimelineType.default
  });
  const createTimeline = (0, _react.useCallback)(({
    from: fromTimeline,
    timeline,
    to: toTimeline,
    ruleNote
  }) => {
    var _timeline$indexNames;
    clearActiveTimeline();
    updateTimelineIsLoading({
      id: _timeline.TimelineId.active,
      isLoading: false
    });
    (0, _helpers.dispatchUpdateTimeline)(dispatch)({
      duplicate: true,
      from: fromTimeline,
      id: _timeline.TimelineId.active,
      notes: [],
      timeline: {
        ...timeline,
        filterManager,
        indexNames: (_timeline$indexNames = timeline.indexNames) !== null && _timeline$indexNames !== void 0 ? _timeline$indexNames : [],
        show: true
      },
      to: toTimeline,
      ruleNote
    })();
  }, [dispatch, filterManager, updateTimelineIsLoading, clearActiveTimeline]);
  const investigateInTimelineClick = (0, _react.useCallback)(async () => {
    startTransaction({
      name: `${_constants.APP_UI_ID} threat indicator investigateInTimeline`
    });
    await createTimeline({
      from,
      notes: null,
      timeline: {
        ..._defaults.timelineDefaults,
        dataProviders,
        id: _timeline.TimelineId.active,
        indexNames: [],
        dateRange: {
          start: from,
          end: to
        },
        eventType: 'all',
        filters: [],
        kqlQuery: {
          filterQuery: {
            kuery: {
              kind: 'kuery',
              expression: ''
            },
            serializedQuery: ''
          }
        }
      },
      to,
      ruleNote: ''
    });
  }, [startTransaction, createTimeline, dataProviders, from, to]);
  return investigateInTimelineClick;
};
exports.useInvestigateInTimeline = useInvestigateInTimeline;