"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NodeSubMenuComponents = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _use_colors = require("./use_colors");
var _use_link_props = require("./use_link_props");
var _side_effect_context = require("./side_effect_context");
var _formatted_number = require("../../common/components/formatted_number");
var _actions = require("../store/actions");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * A Submenu that displays a collection of "pills" for each related event
 * category it has events for.
 */
// eslint-disable-next-line react/display-name
const NodeSubMenuComponents = /*#__PURE__*/_react.default.memo(({
  id,
  className,
  nodeID,
  nodeStats
}) => {
  const relatedEventOptions = (0, _react.useMemo)(() => {
    if (nodeStats === undefined) {
      return [];
    } else {
      return Object.entries(nodeStats.byCategory).map(([category, total]) => {
        const prefix = /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
          count: total || 0
        });
        return {
          prefix,
          category
        };
      });
    }
  }, [nodeStats]);
  if (relatedEventOptions === undefined) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("ul", {
    className: `${className} options`,
    "aria-describedby": nodeID
  }, relatedEventOptions.sort((opta, optb) => {
    return opta.category.localeCompare(optb.category);
  }).map(pill => {
    return /*#__PURE__*/_react.default.createElement(NodeSubmenuPill, {
      id: id,
      pill: pill,
      nodeID: nodeID,
      key: pill.category
    });
  }));
});
exports.NodeSubMenuComponents = NodeSubMenuComponents;
const NodeSubmenuPill = ({
  id,
  pill,
  nodeID
}) => {
  const linkProps = (0, _use_link_props.useLinkProps)(id, {
    panelView: 'nodeEventsInCategory',
    panelParameters: {
      nodeID,
      eventCategory: pill.category
    }
  });
  const {
    pillStroke: pillBorderStroke,
    resolverBackground: pillFill
  } = (0, _use_colors.useColors)();
  const listStylesFromTheme = (0, _react.useMemo)(() => {
    return {
      border: `1.5px solid ${pillBorderStroke}`,
      backgroundColor: pillFill
    };
  }, [pillBorderStroke, pillFill]);
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    timestamp
  } = (0, _react.useContext)(_side_effect_context.SideEffectContext);
  const handleOnClick = (0, _react.useCallback)(mouseEvent => {
    linkProps.onClick(mouseEvent);
    dispatch((0, _actions.userSelectedResolverNode)({
      id,
      nodeID,
      time: timestamp()
    }));
  }, [timestamp, linkProps, dispatch, nodeID, id]);
  return /*#__PURE__*/_react.default.createElement("li", {
    className: "item",
    "data-test-subj": "resolver:map:node-submenu-item",
    style: listStylesFromTheme,
    key: pill.category
  }, /*#__PURE__*/_react.default.createElement("button", {
    type: "button",
    className: "kbn-resetFocusState",
    onClick: handleOnClick
  }, pill.prefix, " ", pill.category));
};